package com.patzn.lims.drug.service.impl;

import com.baomidou.mybatisplus.core.toolkit.*;
import com.patzn.lims.common.ObjectUtils;
import com.patzn.lims.common.StringHandleUtils;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.drug.dto.DrugItemRelEquipDTO;
import com.patzn.lims.drug.entity.*;
import com.patzn.lims.drug.eunms.ItemStatusEnum;
import com.patzn.lims.drug.eunms.SampleStatusEnum;
import com.patzn.lims.drug.eunms.SingleJudgeEnum;
import com.patzn.lims.drug.mapper.DrugItemMapper;
import com.patzn.lims.drug.service.*;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.drug.vo.DrugItemVO;
//import com.patzn.lims.sys.service.ISysMessageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import java.util.*;
import java.util.stream.Collectors;
/**
 * <p>
 * 食药资质项目表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Service
public class DrugItemServiceImpl extends BaseServiceImpl<DrugItemMapper, DrugItem> implements IDrugItemService {

    @Autowired
    private IDrugItemAllocateService drugItemAllocateService;
    @Autowired
    private IDrugItemOperationService drugItemOperationService;
    @Autowired
    private IDrugItemRecordService drugItemRecordService;
    @Autowired
    private IDrugSampleService drugSampleService;
    @Autowired
    private IDrugSampleOperationService drugSampleOperationService;
    @Autowired
    private IDrugItemRelEquipService drugItemRelEquipService;

    @Autowired
    private ITestValueExtendService testValueExtendService;

//    @Autowired
//    private ISysMessageService sysMessageService;

    @Override
    public Page<DrugItem> page(Page<DrugItem> page, DrugItem drugItem) {
        QueryWrapper<DrugItem> wrapper = Wrappers.<DrugItem>query(drugItem);
        return this.page(page, wrapper);
    }

    @Override
    public Page<DrugItemVO> pageAllocate(Page<DrugItemVO> page, DrugItemVO vo) {
        return baseMapper.selectAllocateVOList(page,vo);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean allocateItem(Long[] ids, DrugItemAllocate allocate, Account account) {
        ObjectUtils.checkNull(ids);
        if (null == allocate || allocate.getUserId() == null || StringUtils.isBlank(allocate.getUserName())){
            PtAssert.fail("请选择检测人");
        }

        List<DrugItemAllocate> saveList = new ArrayList<>();
        for (Long id:ids) {
            DrugItemAllocate itemAllocate = new DrugItemAllocate();
            itemAllocate.setAllocateId(account.getUserId());
            itemAllocate.setAllocateTime(new Date());
            itemAllocate.setUserId(allocate.getUserId());
            itemAllocate.setUserName(allocate.getUserName());
            itemAllocate.setItemId(id);
            saveList.add(itemAllocate);

        }

        DrugItem drugItem = new DrugItem();
        drugItem.setStatus(ItemStatusEnum.INPUT);
        drugItem.setProgress(ItemStatusEnum.INPUT);
        if (update(drugItem,Wrappers.<DrugItem>query().in("id",ids))){
           return drugItemAllocateService.saveBatch(saveList);
        }

        return false;
    }

    @Override
    public Page<DrugItemVO> pageVO(Page page, DrugItemVO vo) {

        Page<DrugItemVO> voPage=   baseMapper.selectVOList(page,vo);
        List<DrugItemVO> list=  voPage.getRecords();
        if (CollectionUtils.isEmpty(list)){
            return voPage;
        }
        List<Long> itemIds = list.stream().map(i->{
            return i.getId();
        }).collect(Collectors.toList());
        List<TestValueExtend> testValueExtends = testValueExtendService.list(Wrappers.<TestValueExtend>query().in("item_id",itemIds));
        Map<Long,Set<String>> extendsMap = new HashMap<>();
        for (TestValueExtend extend:testValueExtends) {
            if (extendsMap.containsKey(extend.getItemId())){
                Set<String> set=  extendsMap.get(extend.getItemId());
                set.add(extend.toDefectsString());
                extendsMap.put(extend.getItemId(),set);
            }else{
                Set<String> set= new HashSet<>();
                set.add(extend.toDefectsString());
                extendsMap.put(extend.getItemId(),set);
            }
        }


        for (DrugItemVO itemVO:list) {
            Set<String> setDef= extendsMap.get(itemVO.getId());
            if (null!=setDef){
                String des=  StringHandleUtils.joinNormal(setDef,"\r\n");
                itemVO.setDefects(des);
            }
        }
     return  voPage;
    }

    @Override
    public Page<DrugItemVO> pageVOInput(Page page, DrugItemVO vo) {

        Page<DrugItemVO> voPage=  baseMapper.selectVOInputList(page,vo);
        List<DrugItemVO> list=  voPage.getRecords();
        if (CollectionUtils.isEmpty(list)){
            return voPage;
        }
        List<Long> itemIds = list.stream().map(i->{
            return i.getId();
        }).collect(Collectors.toList());

        List<DrugItemRelEquip> relEquipList = drugItemRelEquipService.list(Wrappers.<DrugItemRelEquip>query().in("item_id",itemIds));
        Map<Long,Set<String>> equipMap = new HashMap<>();
        for (DrugItemRelEquip relEquip:relEquipList) {
            if (equipMap.containsKey(relEquip.getItemId())){
                Set<String> set=  equipMap.get(relEquip.getItemId());
                set.add(relEquip.getEquipName());
                equipMap.put(relEquip.getItemId(),set);
            }else{
                Set<String> set= new HashSet<>();
                set.add(relEquip.getEquipName());
                equipMap.put(relEquip.getItemId(),set);
            }
        }



        List<TestValueExtend> testValueExtends = testValueExtendService.list(Wrappers.<TestValueExtend>query().in("item_id",itemIds));
        Map<Long,Set<String>> extendsMap = new HashMap<>();
        for (TestValueExtend extend:testValueExtends) {
            if (extendsMap.containsKey(extend.getItemId())){
                Set<String> set=  extendsMap.get(extend.getItemId());
                set.add(extend.toDefectsString());
                extendsMap.put(extend.getItemId(),set);
            }else{
                Set<String> set= new HashSet<>();
                set.add(extend.toDefectsString());
                extendsMap.put(extend.getItemId(),set);
            }
        }




        for (DrugItemVO itemVO:list) {
            Set<String> set= equipMap.get(itemVO.getId());
            if (null!=set){
                itemVO.setEquipNames(StringHandleUtils.join(set));
            }


            Set<String> setDef= extendsMap.get(itemVO.getId());
            if (null!=setDef){
                String des=  StringHandleUtils.joinNormal(setDef,"\r\n");
                itemVO.setDefects(des);
            }
        }
        voPage.setRecords(list);
        return voPage;
    }


    @Override
    public boolean bathWriteValue(Long[] itemIds, DrugItem drugItem, Account account) {
        ObjectUtils.checkNull(itemIds);
        PtAssert.fail(StringUtils.isBlank(drugItem.getTestValue()),"检测值不能为空");

        List<DrugItem> itemList = list(Wrappers.<DrugItem>query().in("id",itemIds));


        List<DrugItem> updateList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(itemList)){
            for (DrugItem item:itemList) {
                DrugItem updateItem = new DrugItem();
                updateItem.setId(item.getId());
                updateItem.setJudged(item.getJudged());
                updateItem.setTestValue(drugItem.getTestValue());

                updateList.add(judgeItem(drugItem.getTestValue(),updateItem,item));
            }
        }
        return updateBatchById(updateList);
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean bathConfirmItem(Long[] itemIds, Account account) {
        ObjectUtils.checkNull(itemIds);

        List<DrugItem> itemList = list(Wrappers.<DrugItem>query().in("id",itemIds));

        List<Long> blankIds = new ArrayList<>();

        for (DrugItem item: itemList) {
            //PtAssert.fail("检测项目"+item.getName()+"的检测值未填写");
            if (StringUtils.isBlank(item.getTestValue())){
                blankIds.add(item.getId());
            }
            PtAssert.fail(SingleJudgeEnum.WAIT.equals(item.getSingleJudge()),"检测项目"+item.getName()+"未判定");
        }
        if (CollectionUtils.isNotEmpty(blankIds)){
            List<TestValueExtend> extendList = testValueExtendService.list(Wrappers.<TestValueExtend>query().select("id","item_id").isNotNull("defect").in("item_id",blankIds));
            for (TestValueExtend extend:extendList) {
                blankIds.remove(extend.getItemId());
            }
            if (CollectionUtils.isNotEmpty(blankIds)){
                for (DrugItem item: itemList) {
                    if (blankIds.contains(item.getId())){
                        PtAssert.fail("检测项目"+item.getName()+"的检测值或缺陷未填写");
                    }
                }
            }
        }
        drugItemOperationService.writeTester(itemIds,account);


        return super.update(new DrugItem().setStatus(ItemStatusEnum.CHECK).setProgress(ItemStatusEnum.CHECK),
                Wrappers.<DrugItem>query().in("id",itemIds));

    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean bathConfirmItemEnv(Long[] itemIds, Account account) {
        ObjectUtils.checkNull(itemIds);

        List<DrugItem> itemList = list(Wrappers.<DrugItem>query().in("id",itemIds));
        for (DrugItem item: itemList) {
            if (StringUtils.isBlank(item.getTestValue())){
                PtAssert.fail("检测项目"+item.getName()+"的检测值未填写");
            }
            PtAssert.fail(SingleJudgeEnum.WAIT.equals(item.getSingleJudge()),"检测项目"+item.getName()+"未判定");
        }
        drugItemOperationService.writeTester(itemIds,account);
        return super.update(new DrugItem().setStatus(ItemStatusEnum.ENV_CHECK).setProgress(ItemStatusEnum.ENV_CHECK),
                Wrappers.<DrugItem>query().in("id",itemIds));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean submitCheck(Long[] ids, Account account) {
        ObjectUtils.checkNull(ids);
        int count = super.count(Wrappers.<DrugItem>query().in("id",ids).ne("status",ItemStatusEnum.CHECK));
        PtAssert.fail(count>0,"选择了已经提交的检测项目请确认");

        drugItemOperationService.writeChecker(ids,account);
        drugItemRecordService.record(account,ItemStatusEnum.CHECK,ItemStatusEnum.AUDIT,ids);
//        sysMessageService.sendMsg("/drug/test_manage/audit","数据复核已提交至数据审核，请及时处理","新的数据审核任务",account,null);
//
        return super.update(new DrugItem().setStatus(ItemStatusEnum.AUDIT).setProgress(ItemStatusEnum.AUDIT),
                Wrappers.<DrugItem>query().in("id",ids));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean submitCheckEnv(Long[] ids, Account account) {
        ObjectUtils.checkNull(ids);
        int count = super.count(Wrappers.<DrugItem>query().in("id",ids).ne("status",ItemStatusEnum.ENV_CHECK));
        PtAssert.fail(count>0,"选择了已经提交的检测项目请确认");

        drugItemOperationService.writeChecker(ids,account);
        drugItemRecordService.record(account,ItemStatusEnum.ENV_CHECK,ItemStatusEnum.ENV_AUDIT,ids);

        return super.update(new DrugItem().setStatus(ItemStatusEnum.ENV_AUDIT).setProgress(ItemStatusEnum.ENV_AUDIT),
                Wrappers.<DrugItem>query().in("id",ids));
    }



    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean submitAudit(Long[] ids, Account account) {

        ObjectUtils.checkNull(ids);

        int count = super.count(Wrappers.<DrugItem>query().in("id",ids).ne("status",ItemStatusEnum.AUDIT));
        PtAssert.fail(count>0,"选择了已经提交的检测项目请确认");

        drugItemOperationService.writeAuditor(ids,account);
        drugItemRecordService.record(account,ItemStatusEnum.AUDIT,ItemStatusEnum.END,ids,"数据审核提交");

        List<DrugItem> itemList = super.list(Wrappers.<DrugItem>query().in("id",ids));

        Set<Long> sampleIdSet = new HashSet<>();
        for (DrugItem item: itemList) {
            sampleIdSet.add(item.getSampleId());
        }
       List<Long> sampleIdEnd=new ArrayList<>();
        for (Long sampleId:sampleIdSet) {
           int code = super.count(Wrappers.<DrugItem>query().eq("sample_id",sampleId).notIn("id",ids).ne("status",ItemStatusEnum.END));
           if (code==0){
               sampleIdEnd.add(sampleId);
           }
        }
        if (CollectionUtils.isNotEmpty(sampleIdEnd)){
            DrugSample drugSample=   new DrugSample().setStatus(SampleStatusEnum.REPORT_MAKE).setProgress(SampleStatusEnum.REPORT_MAKE);
            drugSampleService.update(drugSample,Wrappers.<DrugSample>query().in("id",sampleIdEnd));
            drugSampleOperationService.updateSampleToReport(sampleIdEnd,account);
        }
        return super.update(new DrugItem().setStatus(ItemStatusEnum.END).setProgress(ItemStatusEnum.END),
                Wrappers.<DrugItem>query().in("id",ids));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean submitAuditEnv(Long[] ids, Account account) {

        ObjectUtils.checkNull(ids);

        int count = super.count(Wrappers.<DrugItem>query().in("id",ids).ne("status",ItemStatusEnum.ENV_AUDIT));
        PtAssert.fail(count>0,"选择了已经提交的检测项目请确认");

        drugItemOperationService.writeAuditor(ids,account);
        drugItemRecordService.record(account,ItemStatusEnum.ENV_AUDIT,ItemStatusEnum.ENV_END,ids,"数据审核提交");

        List<DrugItem> itemList = super.list(Wrappers.<DrugItem>query().in("id",ids));

        Set<Long> sampleIdSet = new HashSet<>();
        for (DrugItem item: itemList) {
            sampleIdSet.add(item.getSampleId());
        }
        List<Long> sampleIdEnd=new ArrayList<>();
        for (Long sampleId:sampleIdSet) {
            int code = super.count(Wrappers.<DrugItem>query().eq("sample_id",sampleId).notIn("id",ids).ne("status",ItemStatusEnum.ENV_END));
            if (code==0){
                sampleIdEnd.add(sampleId);
            }
        }
        if (CollectionUtils.isNotEmpty(sampleIdEnd)){
            DrugSample drugSample=   new DrugSample().setStatus(SampleStatusEnum.ENV_REPORT_MAKE).setProgress(SampleStatusEnum.ENV_REPORT_MAKE);
            drugSampleService.update(drugSample,Wrappers.<DrugSample>query().in("id",sampleIdEnd));
            drugSampleOperationService.updateSampleToReport(sampleIdEnd,account);
        }
        return super.update(new DrugItem().setStatus(ItemStatusEnum.ENV_END).setProgress(ItemStatusEnum.ENV_END),
                Wrappers.<DrugItem>query().in("id",ids));
    }



    @Override
    public boolean updateByCondition(Long[] ids, ItemStatusEnum allocate) {
        if (ArrayUtils.isEmpty(ids)){
            return  false;
        }
        return super.update(new DrugItem().setProgress(allocate).setStatus(allocate),
                Wrappers.<DrugItem>query().in("sample_id",ids));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean adjustTester(Long[] ids, DrugItemAllocate allocate, Account account) {
         ObjectUtils.checkNull(ids);
        if (null == allocate || allocate.getUserId() == null || StringUtils.isBlank(allocate.getUserName())){
            PtAssert.fail("请选择检测人");
         }

        List<DrugItemAllocate> allocateList = drugItemAllocateService.list(Wrappers.<DrugItemAllocate>query()
        .in("item_id",ids).eq("user_id",allocate.getUserId()));

        Map<Long,Long> mapItemIds=new HashMap<>();
        for (DrugItemAllocate itemAllocate:allocateList) {
            mapItemIds.put(itemAllocate.getItemId(),itemAllocate.getUserId());
        }
        List<DrugItemAllocate> saveList = new ArrayList<>();
        for (Long id:ids) {
            if (null==mapItemIds.get(id)){
                DrugItemAllocate itemAllocate = new DrugItemAllocate();
                itemAllocate.setAllocateId(account.getUserId());
                itemAllocate.setAllocateTime(new Date());
                itemAllocate.setUserId(allocate.getUserId());
                itemAllocate.setUserName(allocate.getUserName());
                itemAllocate.setItemId(id);
                saveList.add(itemAllocate);
            }
        }
        if (CollectionUtils.isNotEmpty(saveList)){
            drugItemAllocateService.saveBatch(saveList);
        }

        return true;
    }

    @Override
    public Page<DrugItemVO> pageDispatch(Page page, DrugItemVO vo) {
        Page<DrugItemVO> drugItemVOPage= baseMapper.selectAllocateVOList(page,vo);
       List<DrugItemVO> list= drugItemVOPage.getRecords();

       List<Long> itemIdList = new ArrayList<>();
       for (DrugItemVO itemVO:list) {
           itemIdList.add(itemVO.getId());
        }

       List<DrugItemAllocate> allocateList = drugItemAllocateService.list(Wrappers.<DrugItemAllocate>query()
       .in("item_id",itemIdList));

        Map<Long,Set<String>> testersMap=new HashMap<>();
        for (DrugItemAllocate drugItemAllocate:allocateList) {
            if (null==testersMap.get(drugItemAllocate.getItemId())){
                Set<String>  sb = new HashSet<>();
                sb.add(drugItemAllocate.getUserName());
                testersMap.put(drugItemAllocate.getItemId(),sb);
            }else{
                Set<String> set = testersMap.get(drugItemAllocate.getItemId());
                testersMap.put(drugItemAllocate.getItemId(),set);
            }
        }
        for (DrugItemVO itemVO:list) {
            Set<String> set = testersMap.get(itemVO.getId());
            if (set.size()>0){
                itemVO.setTesters(StringHandleUtils.join(set));
            }
        }

        drugItemVOPage.setRecords(list);

        return drugItemVOPage;
    }

    @Override
    public boolean handJudge(Long[] ids, DrugItem drugItem, Account account) {
        ObjectUtils.checkNull(ids);
        PtAssert.fail(null == drugItem.getSingleJudge(),"请选择判定结果");
        return super.update(new DrugItem().setSingleJudge(drugItem.getSingleJudge()),
                Wrappers.<DrugItem>query().in("id",ids));
    }



    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean backCheck(Long[] itemIds, Account account, String remark) {
        ObjectUtils.checkNull(itemIds);

        if (StringUtils.isBlank(remark)){
            PtAssert.fail("请填写退回原因");
        }
        int code = super.count(Wrappers.<DrugItem>query().in("id",itemIds).ne("status",ItemStatusEnum.CHECK));
        if (code>0){
            PtAssert.fail("请勿重复退回");
        }
      if (update(new DrugItem().setStatus(ItemStatusEnum.INPUT).setProgress(ItemStatusEnum.BACK_CHECK),
              Wrappers.<DrugItem>query().in("id",itemIds) )){
        return    drugItemRecordService.record(account,ItemStatusEnum.BACK_CHECK,ItemStatusEnum.INPUT,itemIds,1,remark);
      }
        return false;
    }



    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean backCheckEnv(Long[] itemIds, Account account, String remark) {
        ObjectUtils.checkNull(itemIds);

        if (StringUtils.isBlank(remark)){
            PtAssert.fail("请填写退回原因");
        }
        int code = super.count(Wrappers.<DrugItem>query().in("id",itemIds).ne("status",ItemStatusEnum.ENV_CHECK));
        if (code>0){
            PtAssert.fail("请勿重复退回");
        }
        if (update(new DrugItem().setStatus(ItemStatusEnum.ENV_INPUT).setProgress(ItemStatusEnum.BACK_ENV_CHECK),
                Wrappers.<DrugItem>query().in("id",itemIds) )){
            return    drugItemRecordService.record(account,ItemStatusEnum.ENV_CHECK,ItemStatusEnum.ENV_INPUT,itemIds,1,remark);
        }
        return false;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean bathAddEquip(DrugItemRelEquipDTO equipDTO) {

        PtAssert.fail(null==equipDTO,"数据有误");
        List<DrugItemRelEquip> listEquip=  equipDTO.getEquipList();
        PtAssert.fail(CollectionUtils.isEmpty(listEquip),"请选择检测仪器");

        List<Long> equipIds = new ArrayList<>();
        for (DrugItemRelEquip itemRelEquip:listEquip) {
            PtAssert.fail(org.apache.commons.lang3.StringUtils.isEmpty(itemRelEquip.getEquipName()),"仪器名称不能为空");
            PtAssert.fail(null==itemRelEquip.getEquipId(),"仪器ID不能为空");
            PtAssert.fail(StringUtils.isBlank(itemRelEquip.getEquipNum()),"仪器编号不能为空");
            equipIds.add(itemRelEquip.getEquipId());
        }
        List<Long> itemIds= equipDTO.getItemIds();
        PtAssert.fail(CollectionUtils.isEmpty(itemIds),"请选择检测项目");

        List<DrugItemRelEquip> relEquipList = drugItemRelEquipService.list(Wrappers.<DrugItemRelEquip>query().in("item_id",itemIds).in("equip_id",equipIds));



        Map<String,String> equipCheckMap = new HashMap<>();

        for (DrugItemRelEquip relEquip:relEquipList) {
            equipCheckMap.put(relEquip.getItemId()+"------"+relEquip.getEquipId(),"------") ;
        }
        List<DrugItemRelEquip> saveList=new ArrayList<>();
        for (Long itemId:itemIds) {
            for (DrugItemRelEquip itemRelEquip:listEquip) {
                if (equipCheckMap.get(itemId+"------"+itemRelEquip.getEquipId())==null){
                    DrugItemRelEquip saveRelEquip=itemRelEquip.convert(DrugItemRelEquip.class);
                    saveRelEquip.setId(IdWorker.getId());
                    saveRelEquip.setItemId(itemId);
                    saveList.add(saveRelEquip);
                }
            }
        }

       if (CollectionUtils.isNotEmpty(saveList)){
         return   drugItemRelEquipService.saveBatch(saveList);
       }
        return true;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean backAudit(Long[] itemIds, Account account, String remark) {
        ObjectUtils.checkNull(itemIds);
        if (StringUtils.isBlank(remark)){
            PtAssert.fail("请填写退回原因");
        }
        int code = super.count(Wrappers.<DrugItem>query().in("id",itemIds).ne("status",ItemStatusEnum.AUDIT));
        if (code>0){
            PtAssert.fail("请勿重复退回");
        }
        if (update(new DrugItem().setStatus(ItemStatusEnum.INPUT).setProgress(ItemStatusEnum.BACK_AUDIT),
                Wrappers.<DrugItem>query().in("id",itemIds) )){
            return    drugItemRecordService.record(account,ItemStatusEnum.BACK_AUDIT,ItemStatusEnum.INPUT,itemIds,1,remark);
        }
        return false;
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean backAuditEnv(Long[] itemIds, Account account, String remark) {
        ObjectUtils.checkNull(itemIds);
        if (StringUtils.isBlank(remark)){
            PtAssert.fail("请填写退回原因");
        }
        int code = super.count(Wrappers.<DrugItem>query().in("id",itemIds).ne("status",ItemStatusEnum.ENV_AUDIT));
        if (code>0){
            PtAssert.fail("请勿重复退回");
        }
        if (update(new DrugItem().setStatus(ItemStatusEnum.ENV_INPUT).setProgress(ItemStatusEnum.BACK_ENV_AUDIT),
                Wrappers.<DrugItem>query().in("id",itemIds) )){
            return    drugItemRecordService.record(account,ItemStatusEnum.ENV_AUDIT,ItemStatusEnum.ENV_INPUT,itemIds,1,remark);
        }
        return false;
    }



    private DrugItem judgeItem(String testValue, DrugItem updateItem, DrugItem item) {
        if (StringUtils.isBlank(testValue)){
            return updateItem;
        }

        if (!StringHandleUtils.isNumeric(testValue)){
            return updateItem;
        }

        if (0==item.getJudged()){
            return updateItem;
        }
        String limitValue=item.getLimitValue();
        String compareSymbol=item.getCompareSymbol();
        if (StringUtils.isBlank(limitValue)||StringUtils.isBlank(compareSymbol)){
            return updateItem;
        }

        if (!StringHandleUtils.isNumeric(limitValue)){
            return updateItem;
        }
        switch (compareSymbol){
            case "<":
                if (StringHandleUtils.compareBig(testValue,limitValue)<0){
                    updateItem.setSingleJudge(SingleJudgeEnum.PASS);
                }else{
                    updateItem.setSingleJudge(SingleJudgeEnum.FAIL);
                }
                break;
            case "<=":
                if (StringHandleUtils.compareBig(testValue,limitValue)<=0){
                    updateItem.setSingleJudge(SingleJudgeEnum.PASS);
                }else{
                    updateItem.setSingleJudge(SingleJudgeEnum.FAIL);
                }
                break;
            case ">":
                if (StringHandleUtils.compareBig(testValue,limitValue)>0){
                    updateItem.setSingleJudge(SingleJudgeEnum.PASS);
                }else{
                    updateItem.setSingleJudge(SingleJudgeEnum.FAIL);
                }
                break;
            case ">=":
                if (StringHandleUtils.compareBig(testValue,limitValue)>=0){
                    updateItem.setSingleJudge(SingleJudgeEnum.PASS);
                }else{
                    updateItem.setSingleJudge(SingleJudgeEnum.FAIL);
                }
                break;

        }
        return  updateItem;
    }
}
