package com.patzn.lims.drug.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.patzn.lims.common.ObjectUtils;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.drug.dto.DrugSampleKeepDTO;
import com.patzn.lims.drug.entity.DrugSample;
import com.patzn.lims.drug.entity.DrugSampleKeep;
import com.patzn.lims.drug.eunms.KeepStatusEnum;
import com.patzn.lims.drug.eunms.SampleStatusEnum;
import com.patzn.lims.drug.mapper.DrugSampleKeepMapper;
import com.patzn.lims.drug.service.IDrugSampleKeepService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.drug.service.IDrugSampleOperationService;
import com.patzn.lims.drug.service.IDrugSampleRecordService;
import com.patzn.lims.drug.service.IDrugSampleService;
import com.patzn.lims.drug.vo.DrugSampleKeepVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 食药取样表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Service
public class DrugSampleKeepServiceImpl extends BaseServiceImpl<DrugSampleKeepMapper, DrugSampleKeep> implements IDrugSampleKeepService {

    @Autowired
    private IDrugSampleRecordService drugSampleRecordService;
    @Autowired
    private IDrugSampleService drugSampleService;
    @Autowired
    private IDrugSampleOperationService drugSampleOperationService;

    @Override
    public Page<DrugSampleKeep> page(Page<DrugSampleKeep> page, DrugSampleKeep drugSampleKeep) {
        QueryWrapper<DrugSampleKeep> wrapper = Wrappers.<DrugSampleKeep>query(drugSampleKeep);
        return this.page(page, wrapper);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean bathSampleMakeEnd(DrugSampleKeepDTO dto,Long sampleId, Account account) {
        ObjectUtils.checkNull(dto);
        PtAssert.fail(null==sampleId,"样品ID不能为空");
        PtAssert.fail(CollectionUtils.isEmpty(dto.getBackupsDTOS()),"制备内容不能为空");

        List<DrugSampleKeep> keepList = dto.getBackupsDTOS();

        List<Long> sampleIds=new ArrayList<>();

        Set<String> typeSet=new HashSet<>();
        for (DrugSampleKeep backups:keepList) {
            PtAssert.fail(null==backups.getSampleId(),"请选择样品id");
            PtAssert.fail(null==backups.getType(),"请填写制备类型");
            PtAssert.fail(!"留样".equals(backups.getType())&&!"送检样".equals(backups.getType()),
                    "制备类型请选择留样、送检样");
            sampleIds.add(backups.getSampleId());

            typeSet.add(backups.getType());
        }
        if (!typeSet.contains("送检样")){
            PtAssert.fail("不存在送检样请确认");
        }
        if(CollectionUtils.isNotEmpty(keepList)){
            super.saveBatch(keepList);
        }
        DrugSample sample=  new DrugSample();
        sample.setStatus(SampleStatusEnum.SEND).setProgress(SampleStatusEnum.SEND).setId(sampleId);
        drugSampleService.updateById(sample);

        drugSampleOperationService.updateMakeToReceive(account,new Long[]{sampleId});

        drugSampleRecordService.record(account, SampleStatusEnum.MAKE,SampleStatusEnum.SEND,new Long[]{sampleId});

        return true;
    }

    @Override
    public Page<DrugSampleKeepVO> pageSampleKeepVO(Page page, DrugSampleKeepVO vo) {
        return baseMapper.selectSampleKeepVOList(page,vo);
    }



    @Override
    public boolean saveKeepInfo(Long[] ids, DrugSampleKeep keep, Account account) {
        ObjectUtils.checkNull(ids);

        if (StringUtils.isBlank(keep.getPosition())){
            PtAssert.fail("请填写存储位置");
        }
        return update(keep,Wrappers.<DrugSampleKeep>query().in("id",ids));
    }


    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean bathHandleEnd(Long[] ids, DrugSampleKeep keep, Account account) {
        ObjectUtils.checkNull(ids);

        if (StringUtils.isBlank(keep.getHandler())){
            PtAssert.fail("请填写处理人");
        }
        if (null==keep.getHandlerId()){
            PtAssert.fail("请填写处理人");
        }
        if (null==keep.getHandleTime()){
            PtAssert.fail("请填写处理时间");
        }
        keep.setStatus(KeepStatusEnum.HANDLED);
        keep.setProgress(KeepStatusEnum.HANDLED);
        return super.update(keep,Wrappers.<DrugSampleKeep>query().in("id",ids));
    }
}
