package com.patzn.lims.drug.service.impl;

import com.patzn.lims.core.web.Account;
import com.patzn.lims.drug.entity.DrugSampleOperation;
import com.patzn.lims.drug.mapper.DrugSampleOperationMapper;
import com.patzn.lims.drug.service.IDrugSampleOperationService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 食药样品操作表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-03-04
 */
@Service
public class DrugSampleOperationServiceImpl extends BaseServiceImpl<DrugSampleOperationMapper, DrugSampleOperation> implements IDrugSampleOperationService {

    @Override
    public Page<DrugSampleOperation> page(Page<DrugSampleOperation> page, DrugSampleOperation drugSampleOperation) {
        QueryWrapper<DrugSampleOperation> wrapper = Wrappers.<DrugSampleOperation>query(drugSampleOperation);
        return this.page(page, wrapper);
    }

    @Override
    public boolean updateRegisterToMake(Account account, Long[] ids) {
        return super.update(new DrugSampleOperation().setReleaser(account.getUserName()).setReleaserId(account.getUserId())
        .setReleaseTime(new Date()),Wrappers.<DrugSampleOperation>query().in("sample_id",ids));
    }

    @Override
    public boolean updateMakeToReceive(Account account, Long[] ids) {
        return super.update(new DrugSampleOperation().setMaker(account.getUserName()).setMakerId(account.getUserId())
                .setMakeTime(new Date()),Wrappers.<DrugSampleOperation>query().in("sample_id",ids));
    }

    @Override
    public boolean updateSendToReceive(Account account, Long[] ids) {
        return super.update(new DrugSampleOperation().setSender(account.getUserName()).setSenderId(account.getUserId())
                .setSendTime(new Date()),Wrappers.<DrugSampleOperation>query().in("sample_id",ids));
    }

    @Override
    public boolean updateReceiveToTest(Account account, Long[] ids) {
        return super.update(new DrugSampleOperation().setReceiver(account.getUserName()).setReceiverId(account.getUserId())
                .setReceiveTime(new Date()),Wrappers.<DrugSampleOperation>query().in("sample_id",ids));
    }




    @Override
    public boolean updateSampleToReport(List<Long> sampleIdEnd, Account account) {
        return super.update(new DrugSampleOperation().setTestEndTime(new Date()),Wrappers.<DrugSampleOperation>query().in("sample_id",sampleIdEnd));
    }

    @Override
    public boolean updateReportMakeInfo(Long[] ids, Account account) {
        return update(new DrugSampleOperation().setReportMakeTime(new Date())
                        .setReportMaker(account.getUserName()).setReportMakerId(account.getUserId()),
                Wrappers.<DrugSampleOperation>query().in("sample_id",ids));
    }

    @Override
    public boolean updateCheckReportInfo(Long[] ids, Account account) {
        return update(new DrugSampleOperation().setReportCheckTime(new Date())
                        .setReportChecker(account.getUserName()).setReportCheckerId(account.getUserId()),
                Wrappers.<DrugSampleOperation>query().in("sample_id",ids));
    }


    @Override
    public boolean updateIssueReportInfo(Long[] ids, Account account) {
        return update(new DrugSampleOperation().setReportIssueTime(new Date())
                        .setReportIssuer(account.getUserName()).setReportIssuerId(account.getUserId()),
                Wrappers.<DrugSampleOperation>query().in("sample_id",ids));
    }

}
