package com.patzn.lims.drug.service.impl;

import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.patzn.lims.core.web.Account;
import com.patzn.lims.drug.entity.DrugSampleRecord;
import com.patzn.lims.drug.eunms.SampleStatusEnum;
import com.patzn.lims.drug.mapper.DrugSampleRecordMapper;
import com.patzn.lims.drug.service.IDrugSampleRecordService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>
 * 食药样品操作日志表 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Service
public class DrugSampleRecordServiceImpl extends BaseServiceImpl<DrugSampleRecordMapper, DrugSampleRecord> implements IDrugSampleRecordService {

    @Override
    public Page<DrugSampleRecord> page(Page<DrugSampleRecord> page, DrugSampleRecord drugSampleRecord) {
        QueryWrapper<DrugSampleRecord> wrapper = Wrappers.<DrugSampleRecord>query(drugSampleRecord);
        return this.page(page, wrapper);
    }

    @Override
    public boolean record(Account account, SampleStatusEnum from, SampleStatusEnum to, Long[] ids) {
        return record(account,from,to,ids,"物品检测任务下发");
    }

    @Override
    public boolean record(Account account, SampleStatusEnum from, SampleStatusEnum to, Long[] ids, String remark) {
       return record(account,from,to,ids,0,remark);
    }



    @Override
    public boolean record(Account account, SampleStatusEnum from, SampleStatusEnum to, Long[] ids,Integer type, String remark) {
        if (ArrayUtils.isEmpty(ids)){
            return false;
        }
        List<DrugSampleRecord> sampleRecordList = new ArrayList<>();
        for (Long sampleId:ids) {
            DrugSampleRecord sampleRecord = new DrugSampleRecord();
            sampleRecord.setSampleId(sampleId);
            sampleRecord.setOperator(account.getUserName());
            sampleRecord.setOperatorId(account.getUserId());
            sampleRecord.setOrigin(from.getDisplay());
            sampleRecord.setTarget(to.getDisplay());
            sampleRecord.setType(type);
            sampleRecord.setRemark(remark);
            sampleRecordList.add(sampleRecord);
        }

        return saveBatch(sampleRecordList);
    }
}
