package com.patzn.lims.drug.service.impl;

import com.patzn.lims.drug.entity.DrugStandard;
import com.patzn.lims.drug.mapper.DrugStandardMapper;
import com.patzn.lims.drug.service.IDrugStandardService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * <p>
 * 食药检测依据 服务实现类
 * </p>
 *
 * @author wangweidong
 * @since 2020-02-29
 */
@Service
public class DrugStandardServiceImpl extends BaseServiceImpl<DrugStandardMapper, DrugStandard> implements IDrugStandardService {

    @Override
    public Page<DrugStandard> page(Page<DrugStandard> page, DrugStandard drugStandard) {
        QueryWrapper<DrugStandard> wrapper = Wrappers.<DrugStandard>query(drugStandard);
        if (StringUtils.isNotBlank(drugStandard.getCode())){
            wrapper.like("code",drugStandard.getCode());
            drugStandard.setCode(null);
        }

        if (StringUtils.isNotBlank(drugStandard.getName())){
            wrapper.like("name",drugStandard.getName());
            drugStandard.setName(null);
        }
        return this.page(page, wrapper);
    }

    @Override
    public List<DrugStandard> listData(DrugStandard drugStandard) {
        QueryWrapper<DrugStandard> wrapper = Wrappers.<DrugStandard>query(drugStandard);
        if (StringUtils.isNotBlank(drugStandard.getCode())){
            wrapper.like("code",drugStandard.getCode());
            drugStandard.setCode(null);
        }
        if (StringUtils.isNotBlank(drugStandard.getName())){
            wrapper.like("name",drugStandard.getName());
            drugStandard.setCode(null);
        }
        return this.list(wrapper);
    }
}
