package com.patzn.lims.drug.service.impl;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.patzn.lims.drug.entity.DrugTestCatalogue;
import com.patzn.lims.drug.mapper.DrugTestCatalogueMapper;
import com.patzn.lims.drug.service.IDrugTestCatalogueService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.drug.vo.DrugTestCatalogueVO;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 食药检测目录 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Service
public class DrugTestCatalogueServiceImpl extends BaseServiceImpl<DrugTestCatalogueMapper, DrugTestCatalogue> implements IDrugTestCatalogueService {

    @Override
    public Page<DrugTestCatalogue> page(Page<DrugTestCatalogue> page, DrugTestCatalogue drugTestCatalogue) {
        QueryWrapper<DrugTestCatalogue> wrapper = Wrappers.<DrugTestCatalogue>query(drugTestCatalogue);
        if (StringUtils.isNotBlank(drugTestCatalogue.getName())){
            wrapper.like("name",drugTestCatalogue.getName());
            drugTestCatalogue.setName(null);
        }

        if (StringUtils.isNotBlank(drugTestCatalogue.getCode())){
            wrapper.like("code",drugTestCatalogue.getCode());
            drugTestCatalogue.setCode(null);
        }
        return this.page(page, wrapper);
    }

    @Override
    public Page<DrugTestCatalogueVO> pageVO(Page page, DrugTestCatalogueVO drugTestCatalogue) {
        return baseMapper.selectVOList(page,drugTestCatalogue);
    }
}
