package com.patzn.lims.drug.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.google.common.collect.Lists;
import com.patzn.lims.drug.entity.DrugTestType;
import com.patzn.lims.drug.mapper.DrugTestTypeMapper;
import com.patzn.lims.drug.service.IDrugTestTypeService;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 食药物料类型 服务实现类
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Service
public class DrugTestTypeServiceImpl extends BaseServiceImpl<DrugTestTypeMapper, DrugTestType> implements IDrugTestTypeService {

    @Override
    public Page<DrugTestType> page(Page<DrugTestType> page, DrugTestType drugTestType) {
        QueryWrapper<DrugTestType> wrapper = Wrappers.<DrugTestType>query(drugTestType);
        if (StringUtils.isNotBlank(drugTestType.getName())){
            wrapper.like("name",drugTestType.getName());
            drugTestType.setName(null);
        }

        return this.page(page, wrapper);
    }

    @Override
    public List<DrugTestType> getClassList(DrugTestType drugTestType) {
        QueryWrapper<DrugTestType> wrapper = Wrappers.<DrugTestType>query(drugTestType);
        if (StringUtils.isNotBlank(drugTestType.getName())){
            wrapper.like("name",drugTestType.getName());
            drugTestType.setName(null);
        }
        return list(wrapper);
    }

    @Override
    public List<String> getStringList(DrugTestType drugTestType) {
        QueryWrapper<DrugTestType> wrapper = Wrappers.<DrugTestType>query(drugTestType);
        if (StringUtils.isNotBlank(drugTestType.getName())){
            wrapper.like("name",drugTestType.getName());
            drugTestType.setName(null);
        }
        wrapper.select("name").groupBy("name");
        List<DrugTestType> list=  list(wrapper);

        if (CollectionUtils.isNotEmpty(list)){
            List<String> nameList = list.stream().map(i->{
                return i.getName();
            }).collect(Collectors.toList());
         return  nameList;
        }
        return Lists.newArrayList();
    }
}
