package com.patzn.lims.drug.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.patzn.lims.drug.entity.DrugAptitude;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;

@Data
@Accessors(chain = true)
@ApiModel
public class DrugAptitudeVO extends DrugAptitude {
    @JsonSerialize(using = ToStringSerializer.class)
    private Long catalogueId;

    @ApiModelProperty(value = "排序")
    private BigDecimal orderBy;
}
