package com.patzn.lims.drug.vo;

import com.patzn.lims.drug.entity.DrugCatalogueItem;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;


/**
 * <p>
 * 食药检测目录项目
 * </p>
 *
 * @author wwd
 * @since 2020-02-29
 */
@Data
@Accessors(chain = true)
@ApiModel
public class DrugCatalogueItemVO extends DrugCatalogueItem {

	@ApiModelProperty(value = "检测项目名称")
	private String name;

	@ApiModelProperty(value = "检测依据")
	private String code;

	@ApiModelProperty(value = "检测依据名称")
	private String standardName;

	@ApiModelProperty(value = "检测依据Id")
	private Long standardId;

	@ApiModelProperty(value = "检测科室")
	private String groupName;

	@ApiModelProperty(value = "检测科室ID")
	private Long groupId;

	@ApiModelProperty(value = "比较符")
	private String compareSymbol;

	@ApiModelProperty(value = "限量值")
	private String limitValue;

	@ApiModelProperty(value = "单位")
	private String unit;

	@ApiModelProperty(value = "是否系统判定0否1是")
	private Integer judged;

	@ApiModelProperty(value = "合格范围")
	private String validValue;

	@ApiModelProperty(value = "检测值默认值")
	private String defaultValue;


	@ApiModelProperty(value = "检测值默认值")
	private String product;

	@ApiModelProperty(value = "检测值默认值")
	private String type;

}
