package com.patzn.lims.drug.vo;

import com.patzn.lims.drug.entity.DrugItem;
import com.patzn.lims.drug.eunms.ItemStatusEnum;
import com.patzn.lims.drug.eunms.SingleJudgeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

@Data
@Accessors(chain = true)
@ApiModel
public class DrugItemVO extends DrugItem {

    @ApiModelProperty(value = "样品编号")
    private String sampleCode;

    @ApiModelProperty(value = "样品名称")
    private String sampleName;

    @ApiModelProperty(value = "物料编号")
    private String nameCode;

    @ApiModelProperty(value = "业务类型")
    private String category;

    @ApiModelProperty(value = "样品ID")
    private Long [] sampleIds;


    @ApiModelProperty(value = "用户id")
    private Long  uid;


    @ApiModelProperty(value = "已分配的检测人员")
    private String testers;


    @ApiModelProperty(value = "分配时间")
    private Date allocateTime;


    @ApiModelProperty(value = "分配时间")
    private Date testTime;

    @ApiModelProperty(value = "检测项目状态集合")
    private List<ItemStatusEnum> statusList;


    @ApiModelProperty(value = "不查询的单项判定")
    private SingleJudgeEnum singleJudgeNot;

    @ApiModelProperty(value = "仪器名称")
    private String equipNames;

    @ApiModelProperty(value = "缺陷")
    private String defects;

}
