package com.patzn.lims.drug.vo;

import com.patzn.lims.drug.entity.DrugItem;
import com.patzn.lims.drug.entity.DrugSample;
import com.patzn.lims.drug.eunms.ItemStatusEnum;
import com.patzn.lims.drug.eunms.OosStatusEnum;
import com.patzn.lims.drug.eunms.SampleStatusEnum;
import com.patzn.lims.drug.eunms.SingleJudgeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

@Data
@Accessors(chain = true)
@ApiModel
public class DrugSampleOosVO extends DrugSample {

    @ApiModelProperty(value = "检测项目列表")
    private List<DrugItem> itemList;


    @ApiModelProperty(value = "检测项目状态")
    private ItemStatusEnum itemStatus;


    @ApiModelProperty(value = "检测项目状态")
    private List<ItemStatusEnum> itemStatusList;


    @ApiModelProperty(value = "状态列表")
    List<SampleStatusEnum> statusList;


    @ApiModelProperty(value = "oos状态列表")
    List<OosStatusEnum> oosStatusEnumList;


    @ApiModelProperty(value = "样品接收人")
    private String receiver;

    @ApiModelProperty(value = "样品接收时间")
    private Date receiveTime;

    @ApiModelProperty(value = "送样人")
    private String sender;
    @ApiModelProperty(value = "送样时间")
    private Date sendTime;

    @ApiModelProperty(value = "报告是否生成")
    private String reported;



    @ApiModelProperty(value = "请检时间开始")
    private Date pcTimeBegin;

    @ApiModelProperty(value = "请检时间结束")
    private Date pcTimeEnd;


    @ApiModelProperty(value = "样品接收时间开始")
    private Date receiveTimeBegin;


    @ApiModelProperty(value = "样品接收时间结束")
    private Date receiveTimeEnd;


    @ApiModelProperty(value = "项目合格状态")
    private SingleJudgeEnum singleJudgeEnum;

    @ApiModelProperty(value = "不符合项描述")
    private String describable;

    @ApiModelProperty(value = "处理意见")
    private String suggestion;

    @ApiModelProperty(value = "处理人")
    private String handler;

    @ApiModelProperty(value = "处理人ID")
    private Long handlerId;

    @ApiModelProperty(value = "处理时间")
    private Date handleTime;

    @ApiModelProperty(value = "状态")
    private OosStatusEnum oosStatus;

    @ApiModelProperty(value = "进度")
    private OosStatusEnum oosProgress;

    @ApiModelProperty(value = "不合格项目数量")
    private Integer noItemNum;

    @ApiModelProperty(value = "复查样品编号")
    private String recheckCode;

    @ApiModelProperty(value = "不查询的状态")
    private SampleStatusEnum notStatus;
}
