package com.patzn.lims.drug.vo;

import com.patzn.lims.drug.entity.DrugItem;
import com.patzn.lims.drug.entity.DrugSample;
import com.patzn.lims.drug.eunms.ItemStatusEnum;
import com.patzn.lims.drug.eunms.OosStatusEnum;
import com.patzn.lims.drug.eunms.SampleStatusEnum;
import com.patzn.lims.drug.eunms.SingleJudgeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

@Data
@Accessors(chain = true)
@ApiModel
public class DrugSampleVO extends DrugSample {

    @ApiModelProperty(value = "检测项目列表")
    private List<DrugItem> itemList;


    @ApiModelProperty(value = "检测项目状态")
    private ItemStatusEnum itemStatus;


    @ApiModelProperty(value = "检测项目状态")
    private List<ItemStatusEnum> itemStatusList;


    @ApiModelProperty(value = "状态列表")
    List<SampleStatusEnum> statusList;


    @ApiModelProperty(value = "oos状态列表")
    List<OosStatusEnum> oosStatusEnumList;


    @ApiModelProperty(value = "样品接收人")
    private String receiver;

    @ApiModelProperty(value = "样品接收时间")
    private Date receiveTime;

    @ApiModelProperty(value = "送样人")
    private String sender;
    @ApiModelProperty(value = "送样时间")
    private Date sendTime;

    @ApiModelProperty(value = "报告是否生成")
    private String reported;



    @ApiModelProperty(value = "请检时间开始")
    private Date pcTimeBegin;

    @ApiModelProperty(value = "请检时间结束")
    private Date pcTimeEnd;


    @ApiModelProperty(value = "样品接收时间开始")
    private Date receiveTimeBegin;


    @ApiModelProperty(value = "样品接收时间结束")
    private Date receiveTimeEnd;


    @ApiModelProperty(value = "项目合格状态")
    private SingleJudgeEnum singleJudgeEnum;


    @ApiModelProperty(value = "不查询的状态")
    private SampleStatusEnum notStatus;

    @ApiModelProperty(value = "制备人")
    private String maker;
    @ApiModelProperty(value = "制备时间")
    private Date makeTime;


    @ApiModelProperty(value = "制备时间开始")
    private Date makeTimeBegin;

    @ApiModelProperty(value = "制备时间结束")
    private Date makeTimeEnd;


    @ApiModelProperty(value = "送样时间开始")
    private Date sendTimeBegin;

    @ApiModelProperty(value = "送样时间结束")
    private Date sendTimeEnd;

}
