package com.patzn.lims.env.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 环境监测管理
 * </p>
 *
 * @author patzn
 * @since 2017-11-07
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEnvMonitor extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "类型（0常规，1微生物）")
	private Integer type;

    @ApiModelProperty(value = "位置")
	private String location;

    @ApiModelProperty(value = "相对湿度")
	private String humidity;

    @ApiModelProperty(value = "温度")
	private String temperature;

    @ApiModelProperty(value = "浮游菌")
	private String airborneMicrobe;

    @ApiModelProperty(value = "沉降菌")
	private String settlingMicrobe;

    @ApiModelProperty(value = "监测日期")
	private Date monitorDate;

    @ApiModelProperty(value = "记录人")
	private Long recorder;

	@ApiModelProperty(value = "记录人姓名")
    private String recorderName;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

	@ApiModelProperty(value = "最后修改人id")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;

	@ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

	@ApiModelProperty(value = "是否删除")
	@TableLogic
	private Integer deleted;


}
