package com.patzn.lims.env.service.impl;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.web.BaseServiceImpl;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.env.entity.LmsEnvMonitor;
import com.patzn.lims.env.mapper.LmsEnvMonitorMapper;
import com.patzn.lims.env.service.ILmsEnvMonitorService;
import com.patzn.lims.env.vo.LmsEnvMonitorVO;
import com.patzn.lims.res.dto.CollectThCustomerData;
import com.patzn.lims.res.entity.LmsEnvMonitorRecord;
import com.patzn.lims.res.service.ILmsBaseDictService;
import com.patzn.lims.res.service.ILmsEnvMonitorRecordService;
import com.patzn.lims.res.service.ILmsPropertyService;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * <p>
 * 环境监测管理 服务实现类
 * </p>
 *
 * @author patzn
 * @since 2017-11-07
 */
@Service
public class LmsEnvMonitorServiceImpl extends BaseServiceImpl<LmsEnvMonitorMapper, LmsEnvMonitor> implements ILmsEnvMonitorService {

    @Autowired
    private ILmsBaseDictService lmsBaseDictService;
    @Autowired
    private ILmsPropertyService lmsPropertyService;
    @Autowired
    private ILmsEnvMonitorRecordService lmsEnvMonitorRecordService;


    @Override
    public Page<LmsEnvMonitorVO> pageVO(Page<LmsEnvMonitorVO> page, LmsEnvMonitorVO lmsEnvMonitorVO) {
        page.setRecords(baseMapper.selectPageVO(page, lmsEnvMonitorVO));
        return page;
    }

    @Override
    public List<LmsEnvMonitorVO> listVO(LmsEnvMonitorVO lmsEnvMonitorVO) {
        return baseMapper.selectPageVO(lmsEnvMonitorVO);
    }

    @Override
    public LmsEnvMonitorVO getVOById(Long id) {
        return baseMapper.selectVOById(id);
    }

    @Override
    public List<LmsEnvMonitor> selectNormalByIds(List<Long> ids) {
        return baseMapper.selectNormalByIds(ids);
    }

    @Override
    public List<LmsEnvMonitor> selectMicrobeByIds(List<Long> ids) {
        return baseMapper.selectMicrobeByIds(ids);
    }

    @Override
    public boolean updateMonitorById(LmsEnvMonitor lmsEnvMonitor) {
        LmsEnvMonitor oldMonitor=super.getById(lmsEnvMonitor.getId());
        PtAssert.fail(null==lmsEnvMonitor.getId(),"id没有传递");
        String remark;
        if (null!=oldMonitor&&oldMonitor.getType()==1){
            remark= lmsPropertyService.getObjectCompareDifferent(lmsEnvMonitor,oldMonitor,"微生物检测条件对比","微生物检测条件信息修改：");
        }else{
            remark= lmsPropertyService.getObjectCompareDifferent(lmsEnvMonitor,oldMonitor,"常规检测条件对比","常规检测条件信息修改：");
        }

        if (StringUtils.isNotBlank(remark)){
            LmsEnvMonitorRecord record=new LmsEnvMonitorRecord();
            record.setMonitorId(lmsEnvMonitor.getId());
            record.setType(2);
            record.setOperator(LoginHelper.getAccount().getUserName());
            record.setRemark(remark);
            lmsEnvMonitorRecordService.save(record);
        }
        return updateById(lmsEnvMonitor);
    }



    @Override
    public void receiveThData(List<CollectThCustomerData> iotThDataList) {
         if (CollectionUtils.isEmpty(iotThDataList)){
             return;
         }
        LmsEnvMonitor lmsEnvMonitor;

         List<LmsEnvMonitor> saveList = new ArrayList<>();
        for (CollectThCustomerData customerData:iotThDataList ) {
            lmsEnvMonitor= new LmsEnvMonitor();
            if (null!=customerData.getHumidity()){
                lmsEnvMonitor.setHumidity(customerData.getHumidity().toString());
            }
            if (null!=customerData.getTemperature()){
                lmsEnvMonitor.setTemperature(customerData.getTemperature().toString());
            }
            if (null!=customerData.getMonitorTime()){
                Date date= new DateTime(customerData.getMonitorTime()).toDate();
                if (null!=date){
                    lmsEnvMonitor.setMonitorDate(date);
                }
            }
            if (null!=customerData.getCompanyId()){
                lmsEnvMonitor.setCompanyId(customerData.getCompanyId());
            }
          lmsEnvMonitor.setLocation(customerData.getPlace());

            lmsEnvMonitor.setType(1);
            saveList.add(lmsEnvMonitor);
        }
        if (CollectionUtils.isNotEmpty(saveList)){
            saveBatch(saveList);
        }
    }

}
