package com.patzn.lims.equip.controller;
import com.baomidou.kisso.annotation.Action;
import com.baomidou.kisso.annotation.Login;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsEquipCheckDTO;
import com.patzn.lims.equip.entity.LmsEquipCheck;
import com.patzn.lims.equip.entity.LmsEquipCheckDetail;
import com.patzn.lims.equip.entity.LmsEquipFile;
import com.patzn.lims.equip.service.ILmsEquipCheckService;
import com.patzn.lims.equip.vo.LmsEquipCheckManageVO;
import com.patzn.lims.equip.vo.LmsEquipCheckVO;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 期间核查 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Api(description = "期间核查")
@RestController
@RequestMapping("/v1/equip_check")
public class LmsEquipCheckController extends ServiceController<ILmsEquipCheckService, LmsEquipCheck> {

    @Autowired
    private ILmsEquipCheckService lmsEquipCheckService;

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsEquipCheckManageVO>> getPage(LmsEquipCheckManageVO lmsEquipCheckManageVO) {
        return success(lmsEquipCheckService.page(getPage(), lmsEquipCheckManageVO));
    }

    @ApiOperation(value = "详情分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_details")
    public PtResult<IPage<LmsEquipCheckManageVO>> getPageDetails(LmsEquipCheckManageVO lmsEquipCheckManageVO) {
        return success(lmsEquipCheckService.page(getPage(), lmsEquipCheckManageVO));
    }


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipCheck>> getList(LmsEquipCheck lmsEquipCheck) {
        return success(lmsEquipCheckService.list(lmsEquipCheck));
    }

    @ApiOperation(value = "打开修改窗口", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipCheckVO> getVO(@PathVariable("id") Long id) {
        return success(lmsEquipCheckService.getVOById(id));
    }

    @GetMapping("/getTemp/")
    public PtResult<LmsEquipCheckVO> getTemp() {
        return success(lmsEquipCheckService.getTemp());
    }

    @ApiModelProperty(value = "复制一条核查计划")
    @PostMapping("/copy")
    public PtResult<LmsEquipCheckDetail> copyInput(@RequestParam("id") Long id) {
        return success(lmsEquipCheckService.copyInput(id));
    }

    @ApiOperation(value = "新增或编辑时修改信息的提交按钮", notes = "根据指定 id 修改该条数据内容")
    @PutMapping("/")
    public PtResult<Boolean> edit(@RequestBody LmsEquipCheckDTO lmsEquipCheck) {
        return success(lmsEquipCheckService.edit(lmsEquipCheck));
    }

    @ApiOperation(value = "新增时提交", notes = "打开新增窗口之后的提交")
    @PostMapping("/add")
    public PtResult<Boolean> add(LmsEquipCheck lmsEquipCheck) {
        return success(lmsEquipCheckService.add(lmsEquipCheck, 1));
    }
    @ApiOperation(value = "导入", notes = "新增时导入")
    @PostMapping("/import")
    public PtResult<Boolean> importItem(MultipartFile file, @RequestParam("checkId") Long checkId) {
        PtAssert.fail(null == checkId,"数据传输错误!");
        return success(lmsEquipCheckService.importLmsEquipCheck(file,checkId));
    }


    @ApiOperation(value = "编辑时提交", notes = "打开编辑窗口之后的提交")
    @PostMapping("/add_submit")
    public PtResult<Boolean> addSubmit(LmsEquipCheck lmsEquipCheck) {
        return success(lmsEquipCheckService.add(lmsEquipCheck, 0));
    }

    @ApiOperation(value = "新增时批量添加", notes = "新增时批量添加")
    @PostMapping("/addDetail/")
    public PtResult<Boolean> addDetail(@RequestParam("equipIds") Long[] ids, LmsEquipCheckDetail lmsEquipCheckManageVO) {
        return success(lmsEquipCheckService.saveBatchEquipId(ids, lmsEquipCheckManageVO, 1));
    }

    @ApiOperation(value = "编辑时批量添加", notes = "编辑时批量添加")
    @PostMapping("/update_add/")
    public PtResult<Boolean> updateDetail(@RequestParam("equipIds") Long[] ids, LmsEquipCheckDetail lmsEquipCheckDetail) {
        return success(lmsEquipCheckService.saveBatchEquipId(ids, lmsEquipCheckDetail, 0));
    }

    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @DeleteMapping("/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipCheckService.removeByIds(ids));

    }

    @ApiModelProperty(value = "仪器核查计划模糊输入接口")
    @PostMapping("/vague_input/{name}/")
    public PtResult<List<LmsEquipCheckDetail>> vagueInput(@PathVariable("name") String name, @RequestParam("value") String value) {
        return success(lmsEquipCheckService.vagueInput(name, value));
    }

    @ApiModelProperty(value = "批量添加实施")
    @PostMapping("/add/")
    public PtResult<Boolean> batchImplementation(@RequestBody LmsEquipCheckDTO lmsEquipCheckDTO) {
        return success(lmsEquipCheckService.batchImplementation(lmsEquipCheckDTO));
    }

    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsEquipCheckService.approve(taskId, status, reason));
    }

    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsEquipFile> uploadFile(@RequestParam("file") MultipartFile file, LmsEquipCheck lmsEquipCheck, int type) {
        return success(lmsEquipCheckService.uploadFile(file, lmsEquipCheck, type));
    }


    @ApiOperation(value = "下载附件", notes = "下载指定产品的产品附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsEquipCheckService.downloadFile(id, response);
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/{id}/{type}/{checkId}")
    public PtResult<Boolean> deleteFile(@PathVariable("id") Long id, @PathVariable("checkId") Long checkId, @PathVariable("type") int type) {
        return success(lmsEquipCheckService.deleteFiles(id, checkId, type));
    }

    @ApiOperation(value = "上传附件(行)", notes = "上传附件(行)")
    @PostMapping("/uploadFileRow")
    public PtResult<LmsEquipFile> uploadFileRow(@RequestParam("file") MultipartFile file, LmsEquipCheck lmsEquipCheck) {
        return success(lmsEquipCheckService.uploadFileRow(file, lmsEquipCheck));
    }


    @ApiOperation(value = "刪除附件（批量）", notes = "刪除附件（批量）")
    @DeleteMapping("/deleteFileBatch")
    public PtResult<Boolean> deleteFileBatch(@RequestParam("ids") Long[] ids) {
        PtAssert.fail(null == ids, "请选择数据！");
        return success(lmsEquipCheckService.deleteFileBatch(ids));
    }

    @ApiOperation(value = "批量下载文件", notes = "批量下载文件")
    @GetMapping("/downloadBatch")
    @Login(action = Action.Skip)
    public void downloadFiles(@RequestParam("ids") Long[] ids) {
        lmsEquipCheckService.downloadFiles(ids, response);
    }


    @ApiOperation(value = "文件行下载（包含多个附件）", notes = "批量下载文件")
    @GetMapping("/downloadRow")
    @Login(action = Action.Skip)
    public void downloadRow(Long id) {
        lmsEquipCheckService.downloadRow(id, response);
    }

}
