package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipCheckHostory;
import com.patzn.lims.equip.service.ILmsEquipCheckHostoryService;
import com.patzn.lims.equip.vo.LmsEquipCheckHostoryVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 期间核查历史表 前端控制器
 * </p>
 *
 * @author SunYunGang
 * @since 2019-01-07
 */
@Api(description = "期间核查历史表")
@RestController
@RequestMapping("/v1/equip_check_hostory")
public class LmsEquipCheckHostoryController extends ServiceController<ILmsEquipCheckHostoryService, LmsEquipCheckHostory>  {

    @Autowired
    private ILmsEquipCheckHostoryService lmsEquipCheckHostoryService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipCheckHostoryVO>> getPage(LmsEquipCheckHostoryVO lmsEquipCheckHostory) {
        return success(lmsEquipCheckHostoryService.page(getPage(), lmsEquipCheckHostory));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipCheckHostory>> getList(LmsEquipCheckHostory lmsEquipCheckHostory) {
        return success(lmsEquipCheckHostoryService.list(lmsEquipCheckHostory));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsEquipCheckHostory> get(@PathVariable("id") Long id) {
        return success(lmsEquipCheckHostoryService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipCheckHostory lmsEquipCheckHostory) {
        lmsEquipCheckHostory.setId(id);
        return success(lmsEquipCheckHostoryService.updateById(lmsEquipCheckHostory));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsEquipCheckHostory lmsEquipCheckHostory) {
        return success(lmsEquipCheckHostoryService.save(lmsEquipCheckHostory));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipCheckHostoryService.remove(Wrappers.<LmsEquipCheckHostory>query().in("id", ids)));
	}

}
