package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsEquipCheckManageDTO;
import com.patzn.lims.equip.entity.LmsEquipCheckManage;
import com.patzn.lims.equip.service.ILmsEquipCheckManageService;
import com.patzn.lims.equip.vo.LmsEquipCheckManageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 期间核查管理 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-12-09
 */
@Api(description = "期间核查管理")
@RestController
@RequestMapping("/v1/equip_check_manage")
public class LmsEquipCheckManageController extends ServiceController<ILmsEquipCheckManageService, LmsEquipCheckManage> {

    @Autowired
    private ILmsEquipCheckManageService lmsEquipCheckManageService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipCheckManageVO>> getPage(LmsEquipCheckManageDTO lmsEquipCheckManageDTO) {
        return success(lmsEquipCheckManageService.pageVO(getPage(), lmsEquipCheckManageDTO));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipCheckManageVO>> getList(LmsEquipCheckManageDTO lmsEquipCheckManageDTO) {
        return success(lmsEquipCheckManageService.listVO(lmsEquipCheckManageDTO));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipCheckManageVO> getVO(@PathVariable("id") Long id) {
        return success(lmsEquipCheckManageService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipCheckManage lmsEquipCheckManage) {
        return success(lmsEquipCheckManageService.updateById(lmsEquipCheckManage));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsEquipCheckManage lmsEquipCheckManage) {
        return success(lmsEquipCheckManageService.save(lmsEquipCheckManage));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipCheckManageService.remove(Wrappers.<LmsEquipCheckManage>query().in("id", ids)));
	}




}
