package com.patzn.lims.equip.controller;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.common.Tree;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipClass;
import com.patzn.lims.equip.entity.LmsEquipLocation;
import com.patzn.lims.equip.service.ILmsEquipClassService;
import com.patzn.lims.equip.vo.LmsEquipClassVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 仪器分类信息表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Api(description = "仪器分类信息表")
@RestController
@RequestMapping("/v1/equip_class")
public class LmsEquipClassController extends ServiceController<ILmsEquipClassService, LmsEquipClass> {

    @Autowired
    private ILmsEquipClassService lmsEquipClassService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipClassVO>> getPage(LmsEquipClassVO lmsEquipClass) {
        return success(lmsEquipClassService.page(getPage(), lmsEquipClass));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipClass>> getList(LmsEquipClass lmsEquipClass) {
        return success(lmsEquipClassService.list(lmsEquipClass));
    }


    @ApiOperation(value = "获取仪器类别树", notes = "获取仪器类别树")
    @PutMapping("/get_tree")
    public PtResult<List<Tree>> getTree(LmsEquipClass lmsEquipClass) {
        return success(baseService.getTree(lmsEquipClass));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipClassVO> getVO(@PathVariable("id") Long id) {
        return success(lmsEquipClassService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipClass lmsEquipClass) {
        return success(lmsEquipClassService.updateClassById(lmsEquipClass));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsEquipClass lmsEquipClass) {
        return success(lmsEquipClassService.saveClass(lmsEquipClass));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipClassService.removeByIds(ids));
    }

    @ApiOperation(value = "导入仪器类别", notes = "导入仪器类别数据内容")
    @PostMapping("/import")
    public PtResult<Boolean> importEquipClass(MultipartFile file) {
        return success(lmsEquipClassService.importEquipClass(file));
    }
}
