package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipClass;
import com.patzn.lims.equip.entity.LmsEquipClassRole;
import com.patzn.lims.equip.service.ILmsEquipClassRoleService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 仪器类别关联角色表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2018-05-14
 */
@Api(description = "仪器类别关联角色表")
@RestController
@RequestMapping("/v1/equip_class_role")
public class LmsEquipClassRoleController extends ServiceController<ILmsEquipClassRoleService, LmsEquipClassRole>  {

    @Autowired
    private ILmsEquipClassRoleService lmsEquipClassRoleService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipClassRole>> getPage(LmsEquipClassRole lmsEquipClassRole) {
        return success(lmsEquipClassRoleService.page(getPage(), lmsEquipClassRole));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipClassRole>> getList(LmsEquipClassRole lmsEquipClassRole) {
        return success(lmsEquipClassRoleService.list(lmsEquipClassRole));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsEquipClassRole> get(@PathVariable("id") Long id) {
        return success(lmsEquipClassRoleService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipClassRole lmsEquipClassRole) {
        lmsEquipClassRole.setId(id);
        return success(lmsEquipClassRoleService.updateById(lmsEquipClassRole));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsEquipClassRole lmsEquipClassRole) {
        return success(lmsEquipClassRoleService.save(lmsEquipClassRole));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipClassRoleService.remove(Wrappers.<LmsEquipClassRole>query().in("id", ids)));
	}

    @ApiOperation(value = "添加角色关联仪器分类", notes = "添加角色关联仪器分类")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "roleId", value = "角色主键", required = true, paramType = "path", dataType = "long"),
            @ApiImplicitParam(name = "classIds", value = "仪器分类主键集合", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/role_rel_class/{roleId}")
    public PtResult<Boolean> addRoleRelClass(@PathVariable("roleId") Long roleId, Long[] classIds) {
        return success(lmsEquipClassRoleService.saveRoleRelClass(roleId, classIds));
    }

    @ApiOperation(value = "查询当前用户的分类列表", notes = "查询当前用户的分类数据列表")
    @PostMapping("/list_current_user")
    public PtResult<List<LmsEquipClass>> getCurrentUserList() {
        return success(lmsEquipClassRoleService.listByUserId(this.currentUserId()));
    }

    @ApiOperation(value = "查询 roleId 的分类列表", notes = "查询 roleId 的分类数据列表")
    @PostMapping("/list_include_role/{roleId}")
    public PtResult<List<LmsEquipClass>> getListIncludeRole(@PathVariable("roleId") Long roleId) {
        return success(lmsEquipClassRoleService.listIncludeRoleId(roleId));
    }

    @ApiOperation(value = "查询分类树", notes = "查询分类数据列表")
    @PostMapping("/class_tree_all")
    public PtResult<List<LmsEquipClass>> getClassAllTree(String name) {
        return success(lmsEquipClassRoleService.getClassAllTree(name));
    }

    @ApiOperation(value = "查询分类树", notes = "查询分类数据列表")
    @PostMapping("/class_tree")
    public PtResult<List<LmsEquipClass>> getClassTree(LmsEquipClass equipClass) {
        return success(lmsEquipClassRoleService.getClassTree(equipClass, this.getAccount()));
    }

}
