package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipDeliveryOrder;
import com.patzn.lims.equip.service.ILmsEquipDeliveryOrderService;
import com.patzn.lims.equip.vo.EquipOutSockVO;
import com.patzn.lims.equip.vo.LmsEquipDeliveryOrderVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 试验耗材出库单表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Api(tags = "试验耗材出库单表")
@RestController
@RequestMapping("/v1/equip_delivery_order")
public class LmsEquipDeliveryOrderController extends ServiceController<ILmsEquipDeliveryOrderService, LmsEquipDeliveryOrder> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipDeliveryOrder>> getPage(LmsEquipDeliveryOrderVO lmsEquipDeliveryOrder) {
        return success(baseService.page(getPage(), lmsEquipDeliveryOrder));
	}



    @ApiOperation(value = "添加设备出库单", notes = "添加设备出库单自动提交关联记录")
    @PostMapping("/{approve}")
    public PtResult<Boolean> add(@PathVariable("approve") boolean approve, String reason) {
        return success(baseService.save(approve,reason));
    }



    @ApiOperation(value = "分页全部公司列表", notes = "分页全部公司列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/allpage")
    public PtResult<IPage<LmsEquipDeliveryOrder>> getAllPage(LmsEquipDeliveryOrderVO lmsEquipDeliveryOrder) {
        return success(baseService.page(getPage(), lmsEquipDeliveryOrder));
    }


    @ApiOperation(value = "仪器待出库审批单", notes = "分页全部公司列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_wait_out")
    public PtResult<IPage<LmsEquipDeliveryOrder>> getWaitOut(LmsEquipDeliveryOrderVO lmsEquipDeliveryOrder) {
        lmsEquipDeliveryOrder.setStatus(2);
        return success(baseService.page(getPage(), lmsEquipDeliveryOrder));
    }



    @ApiOperation(value = "草稿状态的出库单提交审批", notes = "出库单审批")
    @PostMapping("/submit/{id}")
    public PtResult<Boolean> submit(@PathVariable("id") Long id, String reason) {
        return success(baseService.submit(id,reason));
    }



    @ApiOperation(value = "审核出库单", notes = "审核出库单工作流")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "taskId", value = "任务 ID", required = true, paramType = "path", dataType = "string"),
            @ApiImplicitParam(name = "status", value = "状态", required = true, paramType = "query", dataType = "boolean"),
            @ApiImplicitParam(name = "reason", value = "审核批注", paramType = "query", dataType = "string")
    })
    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(baseService.approve(taskId, status, reason));
    }



    /**
     * 设备出库
     */
    @ApiOperation(value = "根据使用一键出库", notes = "添加使用一键出库")
    @PostMapping("/outstock/{id}")
    public PtResult<Boolean> outStockById(@PathVariable("id") Long id , EquipOutSockVO vo)  {
        return success(baseService.outStockById(id,vo));
    }
}
