package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsEquipInfoDTO;
import com.patzn.lims.equip.entity.LmsEquipInfo;
import com.patzn.lims.equip.entity.LmsEquipPurchaseDetail;
import com.patzn.lims.equip.service.ILmsEquipInfoService;
import com.patzn.lims.equip.vo.LmsEquipInfoVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * ${table.comment} 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-16
 */
@Api(tags = "${table.comment}")
@RestController
@RequestMapping("/v1/equip_info")
public class LmsEquipInfoController extends ServiceController<ILmsEquipInfoService, LmsEquipInfo> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsEquipInfoVO>> getPage(LmsEquipInfoDTO lmsEquipInfoDTO) {
        return success(baseService.page(getPage(), lmsEquipInfoDTO));
    }


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_vo")
    public PtResult<IPage<LmsEquipInfoVO>> getPage(LmsEquipInfoVO lmsEquipClass) {
        return success(baseService.pageVO(getPage(), lmsEquipClass));
    }


    @GetMapping({"/vo/{id}"})
    public PtResult<LmsEquipInfoVO> getVO(@PathVariable Long id) {
        return success(baseService.getVO(id));
    }


    @PostMapping("/addDetail/")
    public PtResult<Boolean> addDetail(LmsEquipPurchaseDetail lmsEquipPurchaseDetail) {
        return success(baseService.addDetail(lmsEquipPurchaseDetail,getAccount()));
    }

}
