package com.patzn.lims.equip.controller;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.common.Tree;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipLocation;
import com.patzn.lims.equip.service.ILmsEquipLocationService;
import com.patzn.lims.equip.vo.LmsEquipLocationVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 仪器位置信息表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-12-16
 */
@Api(description = "仪器位置信息表")
@RestController
@RequestMapping("/v1/equip_location")
public class LmsEquipLocationController extends ServiceController<ILmsEquipLocationService, LmsEquipLocation> {


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipLocationVO>> getPage(LmsEquipLocationVO lmsEquipLocationVO) {
        return success(baseService.pageVO(getPage(), lmsEquipLocationVO));
	}

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipLocationVO>> getList(LmsEquipLocationVO lmsEquipLocationVO) {
        return success(baseService.listVO(lmsEquipLocationVO));
    }

    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipLocationVO> getVO(@PathVariable("id") Long id) {
        return success(baseService.getVOById(id));
    }

    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipLocation lmsEquipLocation) {
        return success(baseService.updateById(lmsEquipLocation));
	}

    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsEquipLocation lmsEquipLocation) {
        return success(baseService.save(lmsEquipLocation));
	}

    @ApiOperation(value = "获取仪器类别树", notes = "获取仪器类别树")
    @PutMapping("/get_tree")
    public PtResult<List<Tree>> getTree(LmsEquipLocation lmsEquipLocation) {
        return success(baseService.getTree(lmsEquipLocation));
    }

    @PostMapping("/uploadFile")
    public PtResult<Boolean> uploadFile(@RequestParam("file") MultipartFile file, LmsEquipLocation lmsEquipLocation){
        return success(baseService.uploadFile(file, lmsEquipLocation));
    }

    @ApiOperation(value = "删除附件", notes = "删除指定产品的产品附件")
    @PostMapping("/deleteFile/")
    public PtResult<Boolean> deleteFile(@RequestParam("id") Long id){
        return success(baseService.deleteFile(id));
    }
}
