package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsApprove;
import com.patzn.lims.equip.dto.LmsEquipMaintainDTO;
import com.patzn.lims.equip.entity.LmsEquipMaintain;
import com.patzn.lims.equip.entity.LmsEquipMaintainDetail;
import com.patzn.lims.equip.service.ILmsEquipMaintainService;
import com.patzn.lims.equip.vo.LmsEquipMaintainDetailVO;
import com.patzn.lims.equip.vo.LmsEquipMaintainVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 仪器保养计划信息表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Api(tags = "仪器保养计划信息表")
@RestController
@RequestMapping("/v1/equip_maintain")
public class LmsEquipMaintainController extends ServiceController<ILmsEquipMaintainService, LmsEquipMaintain> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipMaintain>> getPage(LmsEquipMaintain lmsEquipMaintain) {
        return success(baseService.page(getPage(), lmsEquipMaintain));
	}


    @ApiOperation(value = "查询列表用该page分页列表接口", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_maintain")
    public PtResult<IPage<LmsEquipMaintainVO>> getPageMaintain(LmsEquipMaintainVO vo) {
        return success(baseService.pageMaintain(getPage(), vo));
    }



    @GetMapping("/getTemp/")
    public PtResult<LmsEquipMaintainVO> getTemp() {
        return success(baseService.getTempVO());
    }



    @ApiOperation(value = "编辑时添加", notes = "添加一条数据")
    @PostMapping("/update_add")
    public PtResult<Boolean> updateAdd(@RequestParam("equipIds")Long[]ids, LmsEquipMaintainDetail lmsEquipMaintainDetail) {
        return success(baseService.updateAdd(ids,lmsEquipMaintainDetail));
    }


    @ApiOperation(value = "新增时添加", notes = "批量添加")
    @PostMapping("/addDetail/")
    public PtResult<Boolean> addDetail(@RequestParam("equipIds")Long[]ids, LmsEquipMaintainDetailVO lmsEquipMaintainDetail){
        return success(baseService.saveBatchEquipId(ids,lmsEquipMaintainDetail));
    }


//    @ApiOperation(value = "编辑后提交", notes = "添加一条数据")
//    @PostMapping("/update_submit")
//    public PtResult<Boolean> updateAdd(@RequestBody LmsEquipMaintainDTO lmsEquipMaintainDetail) {
//        return success(baseService.addSubmit(lmsEquipMaintainDetail));
//    }


    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, LmsApprove lmsApprove) {
        return success(baseService.approve(taskId, lmsApprove.getStatus(), lmsApprove.getReason()));
    }


    @ApiOperation(value = "新增时提交", notes = "打开添加页面后的提交")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add( LmsEquipMaintain lmsEquipMaintain) {
        return success(baseService.add(lmsEquipMaintain));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipMaintainVO> getVOById(@PathVariable("id") Long id) {
        return success(baseService.getVOById(id));
    }

}
