package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipMaintainHistory;
import com.patzn.lims.equip.service.ILmsEquipMaintainHistoryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * 仪器保养实施历史表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Api(tags = "仪器保养实施历史表")
@RestController
@RequestMapping("/v1/equip_maintain_history")
public class LmsEquipMaintainHistoryController extends ServiceController<ILmsEquipMaintainHistoryService, LmsEquipMaintainHistory> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipMaintainHistory>> getPage(LmsEquipMaintainHistory lmsEquipMaintainHistory) {
        return success(baseService.page(getPage(), lmsEquipMaintainHistory));
	}

}
