package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsEquipMaintainDTO;
import com.patzn.lims.equip.dto.LmsEquipMaintainManageVO;
import com.patzn.lims.equip.entity.LmsEquipMaintainManage;
import com.patzn.lims.equip.service.ILmsEquipMaintainManageService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * ${table.comment} 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Api(tags = "${table.comment}")
@RestController
@RequestMapping("/v1/equip_maintain_manage")
public class LmsEquipMaintainManageController extends ServiceController<ILmsEquipMaintainManageService, LmsEquipMaintainManage> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsEquipMaintainManageVO>> getPage(LmsEquipMaintainManageVO lmsEquipMaintainManageVO) {
        return success(baseService.pageVO(getPage(), lmsEquipMaintainManageVO));
    }

    @ApiModelProperty(value = "批量添加实施")
    @PostMapping("/add/")
    public PtResult<Boolean> add(@RequestBody LmsEquipMaintainDTO lmsEquipMaintainManage) {
        return success(baseService.add(lmsEquipMaintainManage));
    }

}
