package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsEquipPurchaseDTO;
import com.patzn.lims.equip.entity.LmsEquipPurchase;
import com.patzn.lims.equip.service.ILmsEquipPurchaseService;
import com.patzn.lims.equip.vo.LmsEquipPurchaseVO;
import com.patzn.lims.res.enums.CodeTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.bind.annotation.*;

import java.util.Date;

/**
 * <p>
 * 仪器采购订单表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Api(tags = "仪器采购订单表")
@RestController
@RequestMapping("/v1/equip_purchase")
public class LmsEquipPurchaseController extends ServiceController<ILmsEquipPurchaseService, LmsEquipPurchase> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsEquipPurchase>> getPage(LmsEquipPurchaseDTO lmsEquipPurchase) {
        lmsEquipPurchase.setUserId(getAccount().getUserId());
        return success(baseService.page(getPage(), lmsEquipPurchase));
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsEquipPurchaseVO> getTemp() {
        return success(baseService.getTempVO());
    }



    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipPurchaseVO> getVOById(@PathVariable("id") Long id) {
        return success(baseService.getVOById(id));
    }



    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    public PtResult<Boolean> add(LmsEquipPurchase lmsEquipPurchase,Long sendUserId) {
        return success(baseService.add(lmsEquipPurchase,sendUserId,getAccount()));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/vo/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipPurchaseVO lmsEquipPurchase) {
        baseService.updateById(lmsEquipPurchase);
        //提交
        if (1 == lmsEquipPurchase.getStatus() || 6 == lmsEquipPurchase.getStatus()) {
            baseService.submit(lmsEquipPurchase.getId(),lmsEquipPurchase.getSendUserId());
        }
        return success(true);
    }


    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(baseService.approve(taskId, status, reason));
    }

    @ApiOperation(value = "实验室主任审批", notes = "实验室主任审批")
    @PostMapping("/approve_flow/{taskId}")
    public PtResult<Boolean> approveFlow(@PathVariable("taskId") String taskId, String allow, String postil,Long id,Long sendUserId) {
        return success(baseService.approveFlow(taskId, allow, postil,id,sendUserId));
    }

    @ApiOperation(value = "总经理审批", notes = "总经理审批")
    @PostMapping("/approve_manager/{taskId}")
    public PtResult<Boolean> approveManager(@PathVariable("taskId") String taskId, String allow, String postil) {
        return success(baseService.approveManager(taskId, allow, postil));
    }

    @ApiOperation(value = "一级审批通过按钮", notes = "总经理审批")
    @PostMapping("/to_manager_check/{taskId}")
    public PtResult<Boolean> toManagerCheck(@PathVariable("taskId") String taskId, String allow, String postil) {
        return success(baseService.toManagerCheck(taskId, allow, postil));
    }


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/delete/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        if (ArrayUtils.isEmpty(ids)){
            return success(false);
        }
        return success(baseService.remove(Wrappers.<LmsEquipPurchase>query().in("id",ids)));
    }

}
