package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipPurchaseDetail;
import com.patzn.lims.equip.service.ILmsEquipPurchaseDetailService;
import com.patzn.lims.equip.vo.LmsEquipPurchaseDetailVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * <p>
 * 仪器采购详情信息表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Api(tags = "仪器采购详情信息表")
@RestController
@RequestMapping("/v1/equip_purchase_detail")
public class LmsEquipPurchaseDetailController extends ServiceController<ILmsEquipPurchaseDetailService, LmsEquipPurchaseDetail> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipPurchaseDetail>> getPage(LmsEquipPurchaseDetail lmsEquipPurchaseDetail) {
        return success(baseService.page(getPage(), lmsEquipPurchaseDetail));
	}

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipPurchaseDetailVO>> getList(LmsEquipPurchaseDetailVO lmsEquipPurchaseDetailVO) {
        return success(baseService.listVO(lmsEquipPurchaseDetailVO));
    }



    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/delete/")
    public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        if (ArrayUtils.isEmpty(ids)){
            return success(false);
        }
        return success(baseService.remove(Wrappers.<LmsEquipPurchaseDetail>query().in("id",ids)));
    }

}
