package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipRelDelivery;
import com.patzn.lims.equip.service.ILmsEquipRelDeliveryService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 试验耗材采购关联表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Api(tags = "试验耗材采购关联表")
@RestController
@RequestMapping("/v1/equip_rel_delivery")
public class LmsEquipRelDeliveryController extends ServiceController<ILmsEquipRelDeliveryService, LmsEquipRelDelivery> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipRelDelivery>> getPage(LmsEquipRelDelivery lmsEquipRelDelivery) {
        return success(baseService.page(getPage(), lmsEquipRelDelivery));
	}



    /***
     * 临时出库单
     */
    @ApiOperation(value = "添加临时出库单", notes = "添加一条采购数据")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "chemicalIds", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
    @PostMapping("/addTempDelivery/")
    public PtResult<Boolean> add(@RequestParam("equipIds") Long[] equipIds, LmsEquipRelDelivery lmsEquipRelDelivery) {
        return success(baseService.saveTempDeliveryByIds(equipIds, lmsEquipRelDelivery));
    }


    /**
     * 模糊查询
     */
    @ApiOperation(value = "模糊查询", notes = "查询指定 的数据内容")
    @GetMapping("/searchlike")
    public PtResult<List<String>> searchLike(String item, String name) {
        return success(baseService.searchLike(item,name));
    }



    @ApiOperation(value = "临时出库单分页列表", notes = "分页查询临时出库单数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_temp")
    public PtResult<IPage<LmsEquipRelDelivery>> getPageTemp(LmsEquipRelDelivery lmsEquipRelDelivery) {
        lmsEquipRelDelivery.setUid(currentUserId());
        return success(baseService.pageTemp(getPage(), lmsEquipRelDelivery));
    }

}
