package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipRepair;
import com.patzn.lims.equip.entity.LmsEquipRepairDetail;
import com.patzn.lims.equip.service.ILmsEquipRepairService;
import com.patzn.lims.equip.vo.LmsEquipRepairVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 仪器维修信息表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-30
 */
@Api(tags = "仪器维修信息表")
@RestController
@RequestMapping("/v1/equip_repair")
public class LmsEquipRepairController extends ServiceController<ILmsEquipRepairService, LmsEquipRepair> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipRepair>> getPage(LmsEquipRepair lmsEquipRepair) {
        return success(baseService.page(getPage(), lmsEquipRepair));
	}



    @ApiOperation(value = "仪器维修申请分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_vo")
    public PtResult<IPage<LmsEquipRepairVO>> getPage(LmsEquipRepairVO lmsEquipRepair) {
        lmsEquipRepair.setTempStatus(1);
        return success(baseService.pageVO(getPage(), lmsEquipRepair));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipRepairVO> getVO(@PathVariable("id") Long id) {


        return success(baseService.getVO(id));
    }


    @GetMapping("/getTemp/")
    public PtResult<LmsEquipRepairVO> getTemp() {
        return success(baseService.getTemp());
    }


    @GetMapping("/getTemp/{ids}")
    public PtResult<LmsEquipRepairVO> getTemp(@PathVariable("ids")Long [] ids) {
        return success(baseService.getTemp(ids));
    }



    @ApiOperation(value = " 修改主维修单信息点提交", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
    public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipRepair lmsEquipRepair) {

        return success(baseService.edit(lmsEquipRepair));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(LmsEquipRepair lmsEquipRepair) {
        return success(baseService.add(lmsEquipRepair));
    }


    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(baseService.approve(taskId, status, reason));
    }



    @ApiOperation(value = "仪器维修实施分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_manage")
    public PtResult<IPage<LmsEquipRepairVO>> getPageManage(LmsEquipRepairVO lmsEquipRepair) {
        lmsEquipRepair.setTempStatus(1);
        lmsEquipRepair.setStatus(2);
        return success(baseService.pageVO(getPage(), lmsEquipRepair));
    }



}
