package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipRepairDetail;
import com.patzn.lims.equip.service.ILmsEquipRepairDetailService;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 仪器维修详情信息表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-30
 */
@Api(tags = "仪器维修详情信息表")
@RestController
@RequestMapping("/v1/equip_repair_detail")
public class LmsEquipRepairDetailController extends ServiceController<ILmsEquipRepairDetailService, LmsEquipRepairDetail> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipRepairDetail>> getPage(LmsEquipRepairDetail lmsEquipRepairDetail) {
        return success(baseService.page(getPage(), lmsEquipRepairDetail));
	}


    @ApiOperation(value = "批量添加", notes = "批量添加一条数据")
    @PostMapping("/add/")
    public PtResult<Boolean> addEquipIds(@RequestParam("equipIds")Long[]ids, LmsEquipRepairDetail lmsEquipRepairDetail) {
        return success(baseService.saves(ids,lmsEquipRepairDetail));
    }



    @ApiModelProperty(value = "仪器维修模糊输入接口")
    @PostMapping("/vague_input/{name}/")
    public PtResult<List<LmsEquipRepairDetail>>vagueInput(@PathVariable("name") String name, @RequestParam("value") String value) {
        return success(baseService.vagueInput(name,value));
    }

}
