package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsEquipRepairDTO;
import com.patzn.lims.equip.entity.LmsEquipRepair;
import com.patzn.lims.equip.entity.LmsEquipRepairDetail;
import com.patzn.lims.equip.entity.LmsEquipRepairManage;
import com.patzn.lims.equip.service.ILmsEquipRepairManageService;
import com.patzn.lims.equip.vo.LmsEquipRepairVO;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * <p>
 * ${table.comment} 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-30
 */
@Api(tags = "${table.comment}")
@RestController
@RequestMapping("/v1/equip_repair_manage")
public class LmsEquipRepairManageController extends ServiceController<ILmsEquipRepairManageService, LmsEquipRepairManage> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipRepairManage>> getPage(LmsEquipRepairManage lmsEquipRepairManage) {
        return success(baseService.page(getPage(), lmsEquipRepairManage));
	}


    @ApiModelProperty(value = "批量添加实施")
    @PostMapping("/add/")
    public PtResult<Boolean> batchImplementation(@RequestBody LmsEquipRepairDTO lmsEquipRepairDTO) {
        return success(baseService.batchImplementation(lmsEquipRepairDTO));
    }

}
