package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipRepairManageHistory;
import com.patzn.lims.equip.service.ILmsEquipRepairManageHistoryService;
import com.patzn.lims.equip.vo.LmsEquipRepairManageHistoryVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
/**
 * <p>
 * 维修核查表 前端控制器
 * </p>
 *
 * @author 啊大苏打是否
 * @since 2019-01-09
 */
@Api(description = "维修核查表")
@RestController
@RequestMapping("/v1/equip_repair_manage_history")
public class LmsEquipRepairManageHistoryController extends ServiceController<ILmsEquipRepairManageHistoryService, LmsEquipRepairManageHistory> {

    @Autowired
    private ILmsEquipRepairManageHistoryService lmsEquipRepairManageHistoryService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_vo")
	public PtResult<IPage<LmsEquipRepairManageHistoryVO>> getPageVO(LmsEquipRepairManageHistoryVO lmsEquipRepairManageHistory) {
        return success(lmsEquipRepairManageHistoryService.page(getPage(), lmsEquipRepairManageHistory));
	}



    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/{id}")
    @Override
    public PtResult<LmsEquipRepairManageHistory> get(@PathVariable("id") Long id) {
        return success(lmsEquipRepairManageHistoryService.getById(id));
    }



    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsEquipRepairManageHistory lmsEquipRepairManageHistory) {
        return success(lmsEquipRepairManageHistoryService.save(lmsEquipRepairManageHistory));
	}


}
