package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtAssert;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.LoginHelper;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipFile;
import com.patzn.lims.equip.entity.LmsEquipScrap;
import com.patzn.lims.equip.entity.LmsEquipScrapDetail;
import com.patzn.lims.equip.enums.EquipScrapApplyEnum;
import com.patzn.lims.equip.service.ILmsEquipFileService;
import com.patzn.lims.equip.service.ILmsEquipScrapDetailService;
import com.patzn.lims.equip.service.ILmsEquipScrapService;
import com.patzn.lims.equip.vo.LmsEquipScrapDetailVO;
import com.patzn.lims.equip.vo.LmsEquipScrapVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * <p>
 * 仪器报废信息表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Api(description = "仪器报废信息表")
@RestController
@RequestMapping("/v1/equip_scrap")
public class LmsEquipScrapController extends ServiceController<ILmsEquipScrapService,LmsEquipScrap> {

    @Autowired
    private ILmsEquipScrapService lmsEquipScrapService;
    @Autowired
    private ILmsEquipFileService lmsEquipFileService;
    @Autowired
    private ILmsEquipScrapDetailService lmsEquipScrapDetailService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_vo")
	public PtResult<IPage<LmsEquipScrapVO>> getPage(LmsEquipScrapVO vo) {
        vo.setTempStatus(1);
        return success(lmsEquipScrapService.pageVO(getPage(), vo));
	}
    @ApiOperation(value = "核查分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page_manage")
    public PtResult<IPage<LmsEquipScrapVO>> getPageManage(LmsEquipScrapVO vo) {
        vo.setCompanyId(LoginHelper.getAccount().getCompanyId());
        return success(lmsEquipScrapService.pageManage(getPage(), vo));
    }

    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipScrap>> getList(LmsEquipScrap lmsEquipScrap) {
        lmsEquipScrap.setTempStatus(1);
        return success(lmsEquipScrapService.list(lmsEquipScrap));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipScrapVO> getVO(@PathVariable("id") Long id) {
        LmsEquipScrapVO lmsEquipScrapVO = new LmsEquipScrapVO();

        LmsEquipScrap lmsEquipScrap = lmsEquipScrapService.getById(id);
        if (null != lmsEquipScrap){
            LmsEquipScrapDetailVO lmsEquipScrapDetailVO = new LmsEquipScrapDetailVO();
            lmsEquipScrapDetailVO.setScrapId(lmsEquipScrap.getId());
            List<LmsEquipScrapDetailVO> detailVOList = lmsEquipScrapDetailService.listVO(lmsEquipScrapDetailVO);
            BeanUtils.copyProperties(lmsEquipScrap, lmsEquipScrapVO);
            lmsEquipScrapVO.setLmsEquipScrapDetailVOList(detailVOList);
            //获取附件
            LmsEquipFile lmsEquipFile = new LmsEquipFile();
            lmsEquipFile.setRelId(lmsEquipScrap.getId());
            List<LmsEquipFile> lmsEquipFileList = lmsEquipFileService.list(lmsEquipFile);
            lmsEquipScrapVO.setLmsEquipFiles(lmsEquipFileList);
        }

        return success(lmsEquipScrapVO);
    }

    @GetMapping("/getTemp/")
    public PtResult<LmsEquipScrapVO> getTemp() {
        return success(lmsEquipScrapService.getTemp());
    }



    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipScrap lmsEquipScrap) {
        PtAssert.fail(null==lmsEquipScrap.getNum(),"请填写编号");
        PtAssert.fail(!lmsEquipScrapService.inputNum(id,lmsEquipScrap.getNum()),"编号重复");
        lmsEquipScrapService.updateById(lmsEquipScrap);
        //提交

        if (EquipScrapApplyEnum.TECHNOLOGY_CHECK.getValue().equals(lmsEquipScrap.getStatus())
        || EquipScrapApplyEnum.TECHNOLOGY_CHECK_BACK.getValue().equals(lmsEquipScrap.getStatus())){
            lmsEquipScrapService.submit(lmsEquipScrap.getId());
        }

        return success(true);
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsEquipScrap lmsEquipScrap) {

        return success(lmsEquipScrapService.addOne(lmsEquipScrap));
	}
    @ApiOperation(value = "批量添加", notes = "批量添加一条数据")
    @PostMapping("/addDetail/")
    public PtResult<Boolean> addDetail(@RequestParam("equipIds")Long[]ids, LmsEquipScrapDetail lmsEquipScrapDetail){
        return success(lmsEquipScrapDetailService.saves(ids,lmsEquipScrapDetail));
    }



    @DeleteMapping("/deleteDetail/")
    public PtResult<Boolean> deleteDetail(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipScrapDetailService.remove(Wrappers.<LmsEquipScrapDetail>query().in("id", ids)));
    }

    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipScrapService.removeIds(ids));
    }

    @PostMapping("/approve/{taskId}")
    public PtResult<Boolean> approve(@PathVariable("taskId") String taskId, String status, String reason) {
        return success(lmsEquipScrapService.approve(taskId, status, reason));
    }
    @ApiOperation(value = "上传附件", notes = "上传附件")
    @PostMapping("/uploadFile")
    public PtResult<LmsEquipFile> uploadFile(@RequestParam("file") MultipartFile file, LmsEquipScrap lmsEquipScrap, int type){
        return success(lmsEquipScrapService.uploadFile(file, lmsEquipScrap));
    }


    @ApiOperation(value = "下载附件", notes = "下载指定产品的产品附件")
    @GetMapping("/downLoadFile")
    public void downloadFile(Long id) {
        lmsEquipScrapService.downloadFile(id, response);
    }

    @ApiOperation(value = "删除附件", notes = "删除附件")
    @DeleteMapping("/deleteFile/{id}/{type}/{scrapId}")
    public PtResult<Boolean> deleteFile(@PathVariable("id")Long id, @PathVariable("scrapId") Long scrapId, @PathVariable int type){
        return success(lmsEquipScrapService.deleteFiles(id,scrapId));
    }

}
