package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipScrap;
import com.patzn.lims.equip.entity.LmsEquipScrapDetail;
import com.patzn.lims.equip.service.ILmsEquipScrapDetailService;
import com.patzn.lims.equip.vo.LmsEquipScrapDetailVO;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 仪器报废详情信息表 前端控制器
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Api(description = "仪器报废详情信息表")
@RestController
@RequestMapping("/v1/equip_scrap_detail")
public class LmsEquipScrapDetailController extends ServiceController<ILmsEquipScrapDetailService, LmsEquipScrapDetail> {

    @Autowired
    private ILmsEquipScrapDetailService lmsEquipScrapDetailService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipScrapDetailVO>> getPage(LmsEquipScrapDetailVO lmsEquipScrapDetailVO) {
        return success(lmsEquipScrapDetailService.pageVO(getPage(), lmsEquipScrapDetailVO));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipScrapDetailVO>> getList(LmsEquipScrapDetailVO lmsEquipScrapDetailVO) {
        return success(lmsEquipScrapDetailService.listVO(lmsEquipScrapDetailVO));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipScrapDetailVO> getVO(@PathVariable("id") Long id) {
        return success(lmsEquipScrapDetailService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipScrapDetail lmsEquipScrapDetail) {
        return success(lmsEquipScrapDetailService.updateById(lmsEquipScrapDetail));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
	public PtResult<Boolean> add(LmsEquipScrapDetail lmsEquipScrapDetail) {
        return success(lmsEquipScrapDetailService.save(lmsEquipScrapDetail));
	}

    @ApiModelProperty(value = "复制一条保养计划")
    @PostMapping("/copy")
    public PtResult<LmsEquipScrapDetail>copyInput(@RequestParam("id") Long id) {
        return success(lmsEquipScrapDetailService.copyInput(id));
    }
    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipScrapDetailService.remove(Wrappers.<LmsEquipScrapDetail>query().in("id", ids)));
	}

    @ApiModelProperty(value = "仪器报废模糊输入接口")
    @PostMapping("/vague_input/{name}/")
    public PtResult<List<LmsEquipScrapDetail>>vagueInput(@PathVariable("name") String name, @RequestParam("value") String value) {
        return success(lmsEquipScrapDetailService.vagueInput(name,value));
    }

    @ApiOperation(value = "批量维护仪器报废信息", notes = "批量维护仪器报废信息")
    @PostMapping("/bath_scrap")
    public PtResult<Boolean> bathScrapInfo(@RequestParam("ids") Long [] ids, LmsEquipScrapDetail lmsEquipScrapDetail) {
        return success(lmsEquipScrapDetailService.bathScrapInfo(ids,lmsEquipScrapDetail));
    }
}
