package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsEquipScrapDTO;
import com.patzn.lims.equip.dto.LmsEquipScrapManageDTO;
import com.patzn.lims.equip.entity.LmsEquipScrapManage;
import com.patzn.lims.equip.service.ILmsEquipScrapManageService;
import com.patzn.lims.equip.vo.LmsEquipScrapManageVO;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 仪器报废管理 前端控制器
 * </p>
 *
 * @author patzn123
 * @since 2018-01-17
 */
@Api(description = "仪器报废管理")
@RestController
@RequestMapping("/v1/equip_scrap_manage")
public class LmsEquipScrapManageController extends ServiceController<ILmsEquipScrapManageService, LmsEquipScrapManage> {

    @Autowired
    private ILmsEquipScrapManageService lmsEquipScrapManageService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipScrapManageVO>> getPage(LmsEquipScrapManageDTO lmsEquipScrapManageDTO) {
        return success(lmsEquipScrapManageService.pageVO(getPage(), lmsEquipScrapManageDTO));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipScrapManage>> getList(LmsEquipScrapManage lmsEquipScrapManage) {
        return success(lmsEquipScrapManageService.list(lmsEquipScrapManage));
    }

    @ApiModelProperty(value = "批量添加实施")
    @PostMapping("/add/")
    public PtResult<Boolean> batchImplementation(@RequestBody LmsEquipScrapDTO lmsEquipScrapDTO) {
        return success(lmsEquipScrapManageService.batchImplementation(lmsEquipScrapDTO));
    }
    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipScrapManageVO> getVO(@PathVariable("id") Long id) {
        return success(lmsEquipScrapManageService.getVOById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipScrapManage lmsEquipScrapManage) {
        return success(lmsEquipScrapManageService.edit(lmsEquipScrapManage));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsEquipScrapManage lmsEquipScrapManage) {
        return success(lmsEquipScrapManageService.save(lmsEquipScrapManage));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipScrapManageService.remove(Wrappers.<LmsEquipScrapManage>query().in("id", ids)));
	}


    @ApiOperation(value = "根据 ids 提交", notes = "根据 id 数组提交指定的数据内容")
    @PostMapping("/submit/")
    public PtResult<Boolean> submit(@RequestParam("ids") Long[] ids) {
        for (int i=0; i<ids.length; i++) {
            LmsEquipScrapManage lmsEquipScrapManage = new LmsEquipScrapManage();
            lmsEquipScrapManage.setId(ids[i]);
            lmsEquipScrapManage.setStatus(2);
            lmsEquipScrapManageService.updateById(lmsEquipScrapManage);
        }
        return success(true);
    }


    @ApiOperation(value = "根据 ids 废止", notes = "根据 id 数组废止指定的数据内容")
    @PostMapping("/abolish/")
    public PtResult<Boolean> abolish(@RequestParam("ids") Long[] ids) {
        for (int i=0; i<ids.length; i++) {
            LmsEquipScrapManage lmsEquipScrapManage = new LmsEquipScrapManage();
            lmsEquipScrapManage.setId(ids[i]);
            lmsEquipScrapManage.setStatus(3);
            lmsEquipScrapManageService.updateById(lmsEquipScrapManage);
        }
        return success(true);
    }
}
