package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.entity.LmsEquipScrapManageHistory;
import com.patzn.lims.equip.service.ILmsEquipScrapManageHistoryService;
import com.patzn.lims.equip.vo.LmsEquipScrapManageHistoryVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * <p>
 * 仪器报废历史记录表 前端控制器
 * </p>
 *
 * @author 121212
 * @since 2019-01-09
 */
@Api(description = "仪器报废历史记录表")
@RestController
@RequestMapping("/v1/equip_scrap_manage_history")
public class LmsEquipScrapManageHistoryController extends ServiceController<ILmsEquipScrapManageHistoryService, LmsEquipScrapManageHistory> {

    @Autowired
    private ILmsEquipScrapManageHistoryService lmsEquipScrapManageHistoryService;


    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
	public PtResult<IPage<LmsEquipScrapManageHistoryVO>> getPage(LmsEquipScrapManageHistoryVO lmsEquipScrapManageHistory) {
        return success(lmsEquipScrapManageHistoryService.page(getPage(), lmsEquipScrapManageHistory));
	}


    @ApiOperation(value = "查询列表", notes = "查询数据列表")
    @PostMapping("/list")
    public PtResult<List<LmsEquipScrapManageHistory>> getList(LmsEquipScrapManageHistory lmsEquipScrapManageHistory) {
        return success(lmsEquipScrapManageHistoryService.list(lmsEquipScrapManageHistory));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    @Override
    public PtResult<LmsEquipScrapManageHistory> get(@PathVariable("id") Long id) {
        return success(lmsEquipScrapManageHistoryService.getById(id));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/{id}")
	public PtResult<Boolean> edit(@PathVariable("id") Long id, LmsEquipScrapManageHistory lmsEquipScrapManageHistory) {
        lmsEquipScrapManageHistory.setId(id);
        return success(lmsEquipScrapManageHistoryService.updateById(lmsEquipScrapManageHistory));
	}


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
	public PtResult<Boolean> add(LmsEquipScrapManageHistory lmsEquipScrapManageHistory) {
        return success(lmsEquipScrapManageHistoryService.save(lmsEquipScrapManageHistory));
	}


    @ApiOperation(value = "根据 ids 删除", notes = "根据 id 数组删除指定的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "主键数组", required = true, paramType = "query", dataType = "array"),
    })
	@DeleteMapping("/")
	public PtResult<Boolean> delete(@RequestParam("ids") Long[] ids) {
        return success(lmsEquipScrapManageHistoryService.remove(Wrappers.<LmsEquipScrapManageHistory>query().in("id", ids)));
	}

}
