package com.patzn.lims.equip.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.patzn.lims.core.PtConstants;
import com.patzn.lims.core.api.PtResult;
import com.patzn.lims.core.web.ServiceController;
import com.patzn.lims.equip.dto.LmsEquipUseRecordDTO;
import com.patzn.lims.equip.entity.LmsEquipUseRecord;
import com.patzn.lims.equip.service.ILmsEquipUseRecordService;
import com.patzn.lims.equip.vo.LmsEquipUseRecordVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

/**
 * <p>
 * 仪器使用记录信息表 前端控制器
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Api(tags = "仪器使用记录信息表")
@RestController
@RequestMapping("/v1/equip_use_record")
public class LmsEquipUseRecordController extends ServiceController<ILmsEquipUseRecordService, LmsEquipUseRecord> {

    @ApiOperation(value = "分页列表", notes = "分页查询数据列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = PtConstants.PAGE_PAGE, value = "请求数据的页码", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_ROWS, value = "每页条数", required = true, paramType = "query", dataType = "int"),
            @ApiImplicitParam(name = PtConstants.PAGE_SIDX, value = "排序字段", paramType = "query", dataType = "String"),
            @ApiImplicitParam(name = PtConstants.PAGE_SORD, value = "排序方式", paramType = "query", dataType = "String"),
    })
    @PostMapping("/page")
    public PtResult<IPage<LmsEquipUseRecordVO>> getPage(LmsEquipUseRecordDTO lmsEquipUseRecordDTO) {
        lmsEquipUseRecordDTO.setRegisterId(this.currentUserId());
        lmsEquipUseRecordDTO.setType(0);
        return success(baseService.pageVO(getPage(), lmsEquipUseRecordDTO));
    }


    @ApiOperation(value = "查询 id 信息", notes = "查询指定 id 的数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/vo/{id}")
    public PtResult<LmsEquipUseRecordVO> getVOById(@PathVariable("id") Long id) {
        return success(baseService.getVOById(id));
    }


    @ApiOperation(value = "查询id 信息", notes = "查询指定 id 的复制数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @GetMapping("/copy/{id}")
    public PtResult<LmsEquipUseRecordVO> getCopy(@PathVariable("id") Long id) {
        return success(baseService.getCopyVOById(id));
    }


    @ApiOperation(value = "添加", notes = "添加一条数据")
    @PostMapping("/")
    @Override
    public PtResult<Boolean> add(LmsEquipUseRecord lmsEquipUseRecord) {
        return success(baseService.add(lmsEquipUseRecord));
    }


    @ApiOperation(value = "根据 id 修改信息", notes = "根据指定 id 修改该条数据内容")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "主键", required = true, paramType = "path", dataType = "long"),
    })
    @PutMapping("/")
    @Override
    public PtResult<Boolean> edit(LmsEquipUseRecord lmsEquipUseRecord) {
        return success(baseService.edit(lmsEquipUseRecord));
    }

}
