package com.patzn.lims.equip.dto;

import com.patzn.lims.equip.entity.LmsEquipInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;
import java.util.List;

/**
 * <p>
 * 仪器资产信息表
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipInfoDTO extends LmsEquipInfo {

    private Date startBuyDate;

    private Date endBuyDate;

    private Date startEffectDate;

    private Date endEffectDate;

    @ApiModelProperty(value = "委托Ids")
    private Long[] contractIds;

    @ApiModelProperty("查询标志")
    private Integer queryMark;

    @ApiModelProperty("是否根据有效期与当前日期查询")
    private Boolean queryWithEffectDate;

    @ApiModelProperty("有效期字符串")
    private String effectDateStr;

    @ApiModelProperty("关联人员id")
    private Long uid;

    private List<Long> ids;

    private Integer yn;

    private Boolean isEnv;


}
