package com.patzn.lims.equip.dto;
import com.patzn.lims.equip.entity.LmsEquipUseRecord;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 仪器资产信息表
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipUseRecordDTO extends LmsEquipUseRecord {

	private String queryUseStartTime;

	private String queryUseEndTime;

	private String conUseStartTime;

	private String conUseEndTime;

	private String name;

	private String equipNum;

	@ApiModelProperty(value = "实验室编号")
	private String labNum;
	//add
	@ApiModelProperty(value = "制造厂商")
	private String productPlace;
	//add
	@ApiModelProperty(value = "规格")
	private String spec;

	@ApiModelProperty(value = "使用时间查询条件开始")
	private Date queryUseTimeStart;

	@ApiModelProperty(value = "使用时间查询条件结束")
	private Date queryUseTimeEnd;

	@ApiModelProperty(value = "仪器类别")
	private String className;
}
