package com.patzn.lims.equip.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author patzn
 * @since 2017-11-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipCheck extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "计划名称")
	private String name;

    @ApiModelProperty(value = "部门id")
	private Long orgId;

	@ApiModelProperty(value = "部门名称")
    private String orgName;

    @ApiModelProperty(value = "状态")
	private Integer status;

	@ApiModelProperty(value = "申请原因")
    private String applyReason;

    @ApiModelProperty(value = "申请人id")
	private Long applyId;

	@ApiModelProperty(value = "申请人名")
	private String applyName;

    @ApiModelProperty(value = "申请制日期")
	private Date applyTime;

	@ApiModelProperty(value = "建议")
	private String firstStepAdvice;

    @ApiModelProperty(value = "批准人员")
	private Long firstStepId;

	@ApiModelProperty(value = "批准人员名")
	private String firstStepName;

    @ApiModelProperty(value = "批准日期")
	private Date firstStepTime;

    @ApiModelProperty(value = "登记人id")
	private Long registerId;

	@ApiModelProperty(value = "登记人名")
	private String registerName;

    @ApiModelProperty(value = "登记时间")
	private Date registerTime;

	@ApiModelProperty(value = "计划核查开始时间")
	private Date checkStartTimePlan;

	@ApiModelProperty(value = "计划核查结束时间")
	private Date checkEndTimePlan;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "用户id")
	private Long userId;

	@ApiModelProperty(value = "临时状态")
	private Integer tempStatus;

	@ApiModelProperty(value = "是否删除0否1是")
	@TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "计划编号")
	private String num;
}
