package com.patzn.lims.equip.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * <p>
 * 期间核查详情信息表
 * </p>
 *
 * @author SunYunGang
 * @since 2019-01-05
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipCheckDetail extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "核查内容")
	private String checkContent;

    @ApiModelProperty(value = "仪器id")
	private Long equipId;
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    @ApiModelProperty(value = "计划核查开始时间")
	private Date checkStartTimePlan;
	@JsonFormat(pattern = "yyyy-MM-dd HH:mm", timezone = "GMT+8")
    @ApiModelProperty(value = "计划核查结束时间")
	private Date checkEndTimePlan;

    @ApiModelProperty(value = "负责人")
	private String checkName;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "删除0否1是")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "核查计划Id")
	private Long checkId;


}
