package com.patzn.lims.equip.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 期间核查历史表
 * </p>
 *
 * @author SunYunGang
 * @since 2019-01-07
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipCheckHostory extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "创建人id")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

    @ApiModelProperty(value = "企业id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;

    @ApiModelProperty(value = "修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;

    @ApiModelProperty(value = "删除0否1是")
    @TableLogic
	private Integer deleted;

    @ApiModelProperty(value = "0计划1实施")
	private Integer type;

    @ApiModelProperty(value = "操作")
	private String operation;

    @ApiModelProperty(value = "核查内容")
	private String checkContent;

    @ApiModelProperty(value = "部门名")
	private String orgName;

    @ApiModelProperty(value = "核查编号")
	private String num;

    @ApiModelProperty(value = "详情")
	private String details;

    @ApiModelProperty(value = "核查名称")
	private String name;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "期间和查开始时间")
	private Date checkStartTimePlan;

    @ApiModelProperty(value = "期间核查结束时间")
	private Date checkEndTimePlan;

    @ApiModelProperty(value = "期间核查实际结束时间")
	private Date checkEndTimeAct;

    @ApiModelProperty(value = "期间核查实际开始时间")
	private Date checkStartTimeAct;

    @ApiModelProperty(value = "实际核查费用")
	private BigDecimal checkFee;

    @ApiModelProperty(value = "核查负责人")
	private String checkName;

    @ApiModelProperty(value = "核查实际负责人")
	private String checkActName;

    @ApiModelProperty(value = "核查id")
	private Long checkId;

    @ApiModelProperty(value = "创建人")
	private String uname;

	@ApiModelProperty(value = "期间核查开始时间修改后")
	private Date lcheckStartTimePlan;

	@ApiModelProperty(value = "期间核查结束时间修改后")
	private Date lcheckEndTimePlan;

	@ApiModelProperty(value = "期间核查实际结束时间修改后")
	private Date lcheckEndTimeAct;

	@ApiModelProperty(value = "期间核查实际结束搜时间修改前")
	private Date lcheckStartTimeAct;

	@ApiModelProperty(value = "实际核查费用修改后")
	private BigDecimal lcheckFee;

	@ApiModelProperty(value = "核查负责人修改后")
	private String lcheckName;

	@ApiModelProperty(value = "实际核查负责人修改后")
	private String lcheckActName;

}
