package com.patzn.lims.equip.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.Date;

/**
 * <p>
 * 
 * </p>
 *
 * @author patzn
 * @since 2017-12-09
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipCheckManage extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "核查id")
	private Long checkId;

	@ApiModelProperty(value = "状态0审批通过，1提交实施")
	private Integer status;

    @ApiModelProperty(value = "实施过程")
	private String process;

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm")
	@ApiModelProperty(value = "实际核查开始时间")
	private Date checkStartTimeAct;

	@JsonFormat(pattern = "yyyy-MM-dd HH:mm")
	@ApiModelProperty(value = "实际核查结束时间")
	private Date checkEndTimeAct;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

    @ApiModelProperty(value = "实际养护人")
	private String checkActName;

    @ApiModelProperty(value = "维护保养费用")
		private BigDecimal checkFee;

	@ApiModelProperty(value = "创建人")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;

	@ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;


}
