package com.patzn.lims.equip.entity;

import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 试验耗材出库单表
 * </p>
 *
 * @author wwd
 * @since 2020-03-27
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipDeliveryOrder extends BaseEntity {
	@TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(value = "企业 ID")
	private Long companyId;
    @ApiModelProperty(value = "创建人 ID")
	@TableField(fill = FieldFill.INSERT)
	private Long uid;
    @ApiModelProperty(value = "编号DN+ID")
	private String num;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "状态（0草稿、1审批中、2待出库，3审批未通过 ，4已完成）")
	private Integer status;
    @ApiModelProperty(value = "0、正常 1、删除")
    @TableLogic
	private Integer deleted;
    @ApiModelProperty(value = "最后修改人 ID")
	@TableField(fill = FieldFill.UPDATE)
	private Long lid;
    @ApiModelProperty(value = "最后修改时间")
	@TableField(fill = FieldFill.UPDATE)
	private Date ltime;
    @ApiModelProperty(value = "创建时间")
	@TableField(fill = FieldFill.INSERT)
	private Date ctime;
    @ApiModelProperty(value = "申请人")
	private String applyer;
    @ApiModelProperty(value = "科室")
	private String department;
    @ApiModelProperty(value = "登记人")
	private String registrant;
    @ApiModelProperty(value = "审核批注")
	private String postil;
    @ApiModelProperty(value = "审核人")
	private String approval;
    @ApiModelProperty(value = "申请原因")
	private String reason;
	private Integer type;


}
