package com.patzn.lims.equip.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器电子档案表
 * </p>
 *
 * @author wwd
 * @since 2020-03-30
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipElectronicDocuments extends BaseEntity {

    @ApiModelProperty(value = "仪器id")
	private Long equipId;
    @ApiModelProperty(value = "文件名称")
	private String documentName;
    @ApiModelProperty(value = "文件路径")
	private String documentPath;
    @ApiModelProperty(value = "创建时间")
	private Date createTime;
    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "0保养,1报告单，2说明书")
	private Integer type;
    @ApiModelProperty(value = "计划名称")
	private String planName;
    @ApiModelProperty(value = "图片上传事由")
	private String applyReason;
    @ApiModelProperty(value = "用户id")
	private Long applyId;
    @ApiModelProperty(value = "用户姓名")
	private String applyName;


}
