package com.patzn.lims.equip.entity;

import java.math.BigDecimal;
import java.util.Date;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author wwd
 * @since 2020-03-16
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipInfo extends BaseEntity {

	@ApiModelProperty(value = "采购单详情id")
	private Long purchaseDetailId;

	@ApiModelProperty(value = "供应商id")
	private Long supplierId;

	@ApiModelProperty(value = "类型id")
	private Long classId;

	@ApiModelProperty(value = "仪器名称")
	private String name;

	@ApiModelProperty(value = "使用状态（0闲置，1在用，2保养中，3维修中，4已报废）")
	private Integer status;

	@ApiModelProperty(value = "规格型号")
	private String spec;

	@ApiModelProperty(value = "仪器品牌")
	private String brand;

	@ApiModelProperty(value = "仪器单价")
	private BigDecimal price;

	@ApiModelProperty(value = "仪器产地")
	private String productPlace;

	@ApiModelProperty(value = "计量类型")
	private String meterType;

	@ApiModelProperty(value = "精确度等级")
	private String uncertainty;

	@ApiModelProperty(value = "分辨力")
	private String accuracy;

	@ApiModelProperty(value = "使用范围")
	private String range;

	@ApiModelProperty(value = "技术参数")
	private String techParams;

	@ApiModelProperty(value = "仪器编号")
	private String equipNum;

	@ApiModelProperty(value = "数量")
	private Integer counts;

	@ApiModelProperty(value = "证书编号")
	private String ceNum;

	@ApiModelProperty(value = "检定周期（月）")
	private Integer period;

	@ApiModelProperty(value = "购买日期")
	private Date buyDate;

	@ApiModelProperty(value = "有效日期")
	private Date effectDate;

	@ApiModelProperty(value = "设备管理人")
	private Long equipAdminId;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "来源（0手动，1采购）")
	private Integer type;

	@ApiModelProperty(value = "公司id")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;

	@ApiModelProperty(value = "当前用户id")
	private Long userId;

	@ApiModelProperty(value = "临时状态（0临时数据，1正式数据）")
	private Integer tempStatus;

	@ApiModelProperty(value = "实验室编号")
	private String labNum;

	@ApiModelProperty(value = "仪器管理人名称")
	private String equipAdminName;

	@ApiModelProperty(value = "技术参数纯文本")
	private String techParamsText;

	@ApiModelProperty(value = "使用科别id")
	private Long departmentId;

	@ApiModelProperty(value = "使用科别名称")
	private String departmentName;

	@ApiModelProperty(value = "使用地点id")
	private Long locationId;

	@ApiModelProperty(value = "接收日期")
	private Date receiveDate;

	@ApiModelProperty(value = "启用日期")
	private Date startUseDate;

	@ApiModelProperty(value = "用途")
	private String purpose;

	@ApiModelProperty(value = "数据采集类型")
	private String acquisitionType;

	@ApiModelProperty(value = "数据采集地址")
	private String acquisitionAddress;

	@ApiModelProperty(value = "仪器IP地址")
	private String ipAddress;

	@ApiModelProperty(value = "期间核查周期（月）")
	private BigDecimal periodCheckCycle;

	@ApiModelProperty(value = "采集命令")
	private String acquisitionCommand;

	@ApiModelProperty(value = "采集解析器")
	private String acquisitionParser;

	@ApiModelProperty(value = "仪器来源")
	private String source;

	@ApiModelProperty(value = "删除 0、否 1、是")
	@TableLogic
	private Integer deleted;

	@ApiModelProperty(value = "预计使用结束时间")
	private Date expectedDate ;



}
