package com.patzn.lims.equip.entity;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.patzn.lims.core.bean.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器位置信息表
 * </p>
 *
 * @author patzn
 * @since 2017-12-16
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipLocation extends BaseEntity {

	private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "点位名称")
	private String name;

	@JsonSerialize(
			using = ToStringSerializer.class
	)
    @ApiModelProperty(value = "上级位置id")
	private Long pid;

	@ApiModelProperty(value = "图片地址")
	private String imagePath;

    @ApiModelProperty(value = "备注")
	private String remark;

    @ApiModelProperty(value = "公司码")
	@TableField(fill = FieldFill.INSERT)
	private Long companyId;
}
