package com.patzn.lims.equip.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器日志表
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipLog extends BaseEntity {

    @ApiModelProperty(value = "设备id")
	private Long equipId;
    @ApiModelProperty(value = "设备状态1使用，2保养，3维修，4预约使用，5预约保养，6预约维修")
	private Integer status;
    @ApiModelProperty(value = "操作日期")
	private Date operateDate;
    @ApiModelProperty(value = "开始时间")
	private Date startTime;
    @ApiModelProperty(value = "结束时间")
	private Date endTime;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "0计划数据1实际数据")
	private Integer type;
    @ApiModelProperty(value = "关联业务id")
	private Long relId;


}
