package com.patzn.lims.equip.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableLogic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器保养计划信息表
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipMaintain extends BaseEntity {

    @ApiModelProperty(value = "计划名称")
	private String name;
    @ApiModelProperty(value = "登记状态(0草稿，1技术主管审批，2技术主管审批通过，3技术主管审批驳回，4审批完成-通过，5审批完成-不通过)")
	private Integer status;
    @ApiModelProperty(value = "申请原因")
	private String applyReason;
    @ApiModelProperty(value = "申请人员id")
	private Long applyId;
    @ApiModelProperty(value = "申请时间")
	private Date applyTime;
    @ApiModelProperty(value = "技术主管意见")
	private String firstStepAdvice;
    @ApiModelProperty(value = "技术主管id")
	private Long firstStepId;
    @ApiModelProperty(value = "技术主管审批时间")
	private Date firstStepTime;
    @ApiModelProperty(value = "登记人id")
	private Long registerId;
    @ApiModelProperty(value = "登记时间")
	private Date registerTime;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "申请人姓名")
	private String applyName;
    @ApiModelProperty(value = "技术主管姓名")
	private String firstStepName;
    @ApiModelProperty(value = "登记人姓名")
	private String registerName;
    @ApiModelProperty(value = "当前用户id")
	private Long userId;
    @ApiModelProperty(value = "临时状态（0临时数据，1正式数据）")
	private Integer tempStatus;
    @ApiModelProperty(value = "计划编号")
	private String num;
    @ApiModelProperty(value = "删除0否1是")
    @TableLogic
	private Integer deleted;


}
