package com.patzn.lims.equip.entity;

import java.util.Date;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.patzn.lims.core.bean.BaseEntity;
import com.baomidou.mybatisplus.annotation.TableLogic;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 仪器保养计划详情信息表
 * </p>
 *
 * @author wwd
 * @since 2020-03-28
 */
@Data
@Accessors(chain = true)
@ApiModel
public class LmsEquipMaintainDetail extends BaseEntity {

    @ApiModelProperty(value = "保养计划id")
	private Long maintainId;
    @ApiModelProperty(value = "设备id")
	private Long equipId;
    @ApiModelProperty(value = "维保项目名称")
	private String projectName;
    @ApiModelProperty(value = "维保内容")
	private String maintainContent;
    @ApiModelProperty(value = "备注")
	private String remark;
    @ApiModelProperty(value = "公司id")
    @TableField(fill = FieldFill.INSERT)
	private Long companyId;
    @ApiModelProperty(value = "计划维修开始时间")
	private Date maintainStartTimePlan;
    @ApiModelProperty(value = "计划维修结束时间")
	private Date maintainEndTimePlan;
	private String maintainerIds;
    @ApiModelProperty(value = "维护保养人")
	private String maintainerNames;
    @ApiModelProperty(value = "删除0否1是")
    @TableLogic
	private Integer deleted;


}
